/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl.sdb;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import javax.servlet.ServletContext;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SDBDataSource {
    private static final Log log = LogFactory.getLog(SDBDataSource.class);
    private final ConfigurationProperties configProps;

    public SDBDataSource(ServletContext ctx) {
        this.configProps = ConfigurationProperties.getBean(ctx);
    }

    public BasicDataSource getDataSource() {
        BasicDataSource cpds = new BasicDataSource();
        cpds.setDriverClassName(this.getDbDriverClassName());
        cpds.setUrl(SDBDataSource.getJdbcUrl(this.configProps));
        cpds.setUsername(this.configProps.getProperty("VitroConnection.DataSource.username"));
        cpds.setPassword(this.configProps.getProperty("VitroConnection.DataSource.password"));
        cpds.setMaxTotal(this.getMaxActive());
        cpds.setMaxIdle(this.getMaxIdle());
        cpds.setMinEvictableIdleTimeMillis((long)this.getMaxIdleTime());
        cpds.setTestOnBorrow(true);
        cpds.setTestOnReturn(true);
        cpds.setValidationQuery(this.getValidationQuery());
        return cpds;
    }

    private String getDbDriverClassName() {
        return this.configProps.getProperty("VitroConnection.DataSource.driver", "com.mysql.jdbc.Driver");
    }

    private String getValidationQuery() {
        return this.configProps.getProperty("VitroConnection.DataSource.validationQuery", "SELECT 1");
    }

    private int getMaxActive() {
        String maxActiveStr = this.configProps.getProperty("VitroConnection.DataSource.pool.maxActive");
        if (StringUtils.isEmpty((CharSequence)maxActiveStr)) {
            return 40;
        }
        int maxActive = 40;
        try {
            maxActive = Integer.parseInt(maxActiveStr);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Unable to parse connection pool maxActive setting " + maxActiveStr + " as an integer"));
            return 40;
        }
        if (maxActive >= 20) {
            return maxActive;
        }
        log.warn((Object)"Specified value for VitroConnection.DataSource.pool.maxActive is too low. Using minimum value of 20");
        return 20;
    }

    private int getMaxIdle() {
        int maxIdleInt = Math.max(this.getMaxActive() / 4, 10);
        return this.getPropertyAsInt("VitroConnection.DataSource.pool.maxIdle", maxIdleInt);
    }

    private int getMaxIdleTime() {
        return this.getPropertyAsInt("VitroConnection.DataSource.pool.maxIdleTime", 1800);
    }

    private int getMaxIdleTimeExcess() {
        return this.getPropertyAsInt("VitroConnection.DataSource.pool.maxIdleTimeExcess", 300);
    }

    private int getPropertyAsInt(String prop, int defaultValue) {
        String propStr = this.configProps.getProperty(prop);
        if (StringUtils.isEmpty((CharSequence)propStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propStr);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Unable to parse connection pool maxIdle setting " + propStr + " as an integer"));
            return defaultValue;
        }
    }

    static String getJdbcUrl(ConfigurationProperties props) {
        String url = props.getProperty("VitroConnection.DataSource.url");
        if ("MySQL".equals(SDBDataSource.getDbType(props))) {
            if (!url.contains("?")) {
                url = url + "?useUnicode=yes&characterEncoding=utf8&nullNamePatternMatchesAll=true&cachePrepStmts=true&useServerPrepStmts=true&serverTimezone=UTC";
            } else {
                String urlLwr = url.toLowerCase();
                if (!urlLwr.contains("useunicode")) {
                    url = url + "&useUnicode=yes";
                }
                if (!urlLwr.contains("characterencoding")) {
                    url = url + "&characterEncoding=utf8";
                }
                if (!urlLwr.contains("nullnamepatternmatchesall")) {
                    url = url + "&nullNamePatternMatchesAll=true";
                }
                if (!urlLwr.contains("cacheprepstmts")) {
                    url = url + "&cachePrepStmts=true";
                }
                if (!urlLwr.contains("useserverprepstmts")) {
                    url = url + "&useServerPrepStmts=true";
                }
                if (!urlLwr.contains("servertimezone")) {
                    url = url + "&serverTimezone=UTC";
                }
            }
        }
        return url;
    }

    private static String getDbType(ConfigurationProperties props) {
        return props.getProperty("VitroConnection.DataSource.dbtype", "MySQL");
    }
}

