/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.sparql;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="GetClazzObjectProperties", urlPatterns={"/admin/getClazzObjectProperties"})
public class GetClazzObjectProperties
extends BaseEditController {
    private static final Log log = LogFactory.getLog(GetClazzObjectProperties.class);

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_MISCELLANEOUS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        String vClassURI = vreq.getParameter("vClassURI");
        if (vClassURI == null || vClassURI.trim().equals("")) {
            return;
        }
        StringBuilder respo = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        respo.append("<options>");
        ObjectPropertyDao odao = vreq.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        PropertyInstanceDao piDao = vreq.getUnfilteredWebappDaoFactory().getPropertyInstanceDao();
        VClassDao vcDao = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
        List<String> superclassURIs = vcDao.getAllSuperClassURIs(vClassURI);
        superclassURIs.add(vClassURI);
        superclassURIs.addAll(vcDao.getEquivalentClassURIs(vClassURI));
        HashMap<String, PropertyInstance> propInstMap = new HashMap<String, PropertyInstance>();
        for (String classURI : superclassURIs) {
            Collection<PropertyInstance> propInsts = piDao.getAllPropInstByVClass(classURI);
            try {
                for (PropertyInstance propInst : propInsts) {
                    propInstMap.put(propInst.getPropertyURI(), propInst);
                }
            }
            catch (NullPointerException ex) {
            }
        }
        ArrayList propInsts = new ArrayList();
        propInsts.addAll(propInstMap.values());
        Collections.sort(propInsts);
        Iterator propInstIt = propInsts.iterator();
        HashSet<String> opropURIs = new HashSet<String>();
        while (propInstIt.hasNext()) {
            PropertyInstance pi = (PropertyInstance)propInstIt.next();
            if (opropURIs.contains(pi.getPropertyURI())) continue;
            opropURIs.add(pi.getPropertyURI());
            ObjectProperty oprop = odao.getObjectPropertyByURI(pi.getPropertyURI());
            if (oprop == null) continue;
            respo.append("<option><key>").append(oprop.getLocalName()).append("</key>").append("<value>").append(oprop.getURI()).append("</value>").append("</option>");
        }
        respo.append("</options>");
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println(respo);
        out.flush();
        out.close();
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

