/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.services.shortview;

import edu.cornell.mannlib.vitro.webapp.services.shortview.FakeApplicationOntologyService;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewService;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewServiceImpl;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ShortViewServiceSetup
implements ServletContextListener {
    private static final String ATTRIBUTE_NAME = ShortViewService.class.getName();

    public void contextInitialized(ServletContextEvent sce) {
        FakeApplicationOntologyService faker;
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            faker = new FakeApplicationOntologyService(ctx);
        }
        catch (FakeApplicationOntologyService.ShortViewConfigException e) {
            ss.warning(this, "Failed to load the shortview_config.n3 file -- " + e.getMessage(), e);
            faker = new FakeApplicationOntologyService();
        }
        ShortViewServiceImpl svs = new ShortViewServiceImpl(faker);
        ctx.setAttribute(ATTRIBUTE_NAME, (Object)svs);
        ss.info(this, "Started the Short View Service with a ShortViewServiceImpl");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        sce.getServletContext().removeAttribute(ATTRIBUTE_NAME);
    }

    public static ShortViewService getService(ServletContext ctx) {
        return (ShortViewService)ctx.getAttribute(ATTRIBUTE_NAME);
    }
}

