/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringRDFService;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.SelectQueryDocumentModifier;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationReader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectQueryI18nDocumentModifier
extends SelectQueryDocumentModifier
implements DocumentModifier,
ContextModelsUser,
ConfigurationReader {
    private static final Log log = LogFactory.getLog(SelectQueryI18nDocumentModifier.class);
    private String fieldSuffix = "";
    private ArrayList<String> locales = new ArrayList();

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTargetSuffix")
    public void setTargetSuffix(String fieldSuffix) {
        this.fieldSuffix = fieldSuffix;
    }

    @Override
    public void modifyDocument(Individual ind, SearchInputDocument doc) {
        if (this.passesTypeRestrictions(ind) && StringUtils.isNotBlank((CharSequence)this.fieldSuffix)) {
            List<Map<String, List<String>>> maps = this.getTextForQueries(ind);
            for (Map<String, List<String>> map : maps) {
                for (String locale : map.keySet()) {
                    List<String> values = map.get(locale);
                    String fieldName = locale + this.fieldSuffix;
                    doc.addField(fieldName, new Object[]{values});
                }
            }
        }
    }

    protected List<Map<String, List<String>>> getTextForQueries(Individual ind) {
        ArrayList<Map<String, List<String>>> list = new ArrayList<Map<String, List<String>>>();
        for (String query : this.queries) {
            list.add(this.getTextForQuery(query, ind));
        }
        return list;
    }

    protected Map<String, List<String>> getTextForQuery(String query, Individual ind) {
        try {
            QueryHolder queryHolder = new QueryHolder(query).bindToUri("uri", ind.getURI());
            HashMap<String, List<String>> mapLocaleToFields = new HashMap<String, List<String>>();
            for (String locale : this.locales) {
                LanguageFilteringRDFService lfrs = new LanguageFilteringRDFService(this.rdfService, Collections.singletonList(locale));
                List<String> list = SparqlQueryRunner.createSelectQueryContext((RDFService)lfrs, queryHolder).execute().toStringFields(new String[0]).flatten();
                mapLocaleToFields.put(locale, list);
                log.debug((Object)(this.label + " for locale " + locale + " - query: '" + query + "' returns " + list));
            }
            return mapLocaleToFields;
        }
        catch (Throwable t) {
            log.error((Object)("problem while running query '" + query + "'"), t);
            return Collections.emptyMap();
        }
    }

    @Override
    public void setConfigurationProperties(ConfigurationProperties config) {
        String property = config.getProperty("languages.selectableLocales");
        if (!StringUtils.isBlank((CharSequence)property)) {
            String[] values;
            for (String value : values = property.trim().split("\\s*,\\s*")) {
                String locale = value.replace("_", "-");
                this.addLocale(locale);
            }
        }
    }

    private void addLocale(String localeString) {
        if (StringUtils.isBlank((CharSequence)localeString)) {
            return;
        }
        this.locales.add(localeString);
    }
}

