/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputField;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FieldBooster
implements DocumentModifier {
    private final List<String> fieldNames = new ArrayList<String>();
    private volatile Float boost;

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTargetField", minOccurs=1)
    public void addTargetField(String fieldName) {
        this.fieldNames.add(fieldName);
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasBoost", minOccurs=1)
    public void setBoost(float boost) {
        this.boost = Float.valueOf(boost);
    }

    @Validation
    public void validate() {
        HashSet<String> uniqueFieldNames = new HashSet<String>(this.fieldNames);
        ArrayList<String> duplicateFieldNames = new ArrayList<String>(this.fieldNames);
        for (String fn : uniqueFieldNames) {
            duplicateFieldNames.remove(fn);
        }
        if (!duplicateFieldNames.isEmpty()) {
            throw new IllegalStateException("Configuration contains duplicate names for target fields: " + duplicateFieldNames);
        }
    }

    @Override
    public void modifyDocument(Individual individual, SearchInputDocument doc) {
        for (String fieldName : this.fieldNames) {
            SearchInputField field = doc.getField(fieldName);
            if (field == null) continue;
            field.setBoost(field.getBoost() + this.boost.floatValue());
        }
    }

    @Override
    public void shutdown() {
    }

    public String toString() {
        return "FieldBooster[fieldNames=" + this.fieldNames + ", boost=" + this.boost + "]";
    }
}

