/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.solr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;

public class SolrFieldInitializer {
    static void initializeFields(SolrClient queryEngine, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        HashSet<String> fieldSuffixes = new HashSet<String>(Arrays.asList("_label_sort", "_label_display"));
        SolrFieldInitializer.excludeMatchedFields(fieldSuffixes, queryEngine, "dynamicFields");
        SolrFieldInitializer.excludeMatchedFields(fieldSuffixes, queryEngine, "fields");
        SolrFieldInitializer.createMissingFields(fieldSuffixes, updateEngine);
    }

    private static void createMissingFields(Set<String> fieldSuffixes, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        for (String suffix : fieldSuffixes) {
            Map<String, Object> fieldAttributes = SolrFieldInitializer.getFieldAttributes(suffix);
            SchemaRequest.AddDynamicField request = new SchemaRequest.AddDynamicField(fieldAttributes);
            SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)request.process((SolrClient)updateEngine);
            if (response.getStatus() == 0) continue;
            throw new Exception("Creation of missing solr field '*" + suffix + "' failed");
        }
    }

    private static Map<String, Object> getFieldAttributes(String suffix) {
        HashMap<String, Object> fieldAttributes = new HashMap<String, Object>();
        fieldAttributes.put("type", "string");
        fieldAttributes.put("stored", "true");
        fieldAttributes.put("indexed", "true");
        fieldAttributes.put("name", "*" + suffix);
        return fieldAttributes;
    }

    private static void excludeMatchedFields(Set<String> fieldSuffixes, SolrClient queryEngine, String fieldType) throws Exception {
        SolrQuery query = new SolrQuery();
        query.add("qt", new String[]{"/schema/" + fieldType.toLowerCase()});
        QueryResponse response = queryEngine.query((SolrParams)query);
        ArrayList fieldList = (ArrayList)response.getResponse().get(fieldType);
        if (fieldList == null) {
            return;
        }
        HashSet<String> it = new HashSet<String>(fieldSuffixes);
        for (String target : it) {
            for (SimpleOrderedMap field : fieldList) {
                String fieldName = (String)field.get("name");
                if (!fieldName.endsWith(target)) continue;
                fieldSuffixes.remove(target);
            }
        }
    }
}

