/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.JsonTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryConverter {
    private static final Log log = LogFactory.getLog(QueryConverter.class);
    private final SearchQuery query;
    private final Map<String, Object> queryAndFilters;
    private final Map<String, Object> sortFields;
    private final Map<String, Object> facets;
    private final Map<String, Object> highlighter;
    private final List<String> returnFields;
    private final Map<String, Object> fullMap;

    public QueryConverter(SearchQuery query) {
        this.query = query;
        this.queryAndFilters = this.filteredOrNot();
        this.sortFields = this.figureSortFields();
        this.facets = this.figureFacets();
        this.highlighter = this.figureHighlighter();
        this.returnFields = this.figureReturnFields();
        this.fullMap = this.figureFullMap();
    }

    private Map<String, Object> filteredOrNot() {
        if (this.query.getFilters().isEmpty()) {
            return new QueryStringMap((String)this.query.getQuery()).map;
        }
        return this.buildFilterStructure();
    }

    private Map<String, Object> buildFilterStructure() {
        return JsonTree.tree().put("bool", JsonTree.tree().put("must", new QueryStringMap((String)this.query.getQuery()).map).put("filter", this.buildFiltersList())).asMap();
    }

    private List<Map<String, Object>> buildFiltersList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String filter : this.query.getFilters()) {
            list.add(new QueryStringMap((String)filter).map);
        }
        return list;
    }

    private Map<String, Object> figureSortFields() {
        Map<String, SearchQuery.Order> fields = this.query.getSortFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String name : fields.keySet()) {
            String sortOrder = fields.get(name).toString().toLowerCase();
            map.put(name, sortOrder);
        }
        return map;
    }

    private Map<String, Object> figureFacets() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String field : this.query.getFacetFields()) {
            map.put("facet_" + field, this.figureFacet(field));
        }
        return map;
    }

    private Map<String, Object> figureHighlighter() {
        return JsonTree.tree().put("fields", JsonTree.tree().put("ALLTEXT", JsonTree.EMPTY_JSON_MAP)).asMap();
    }

    private Map<String, Object> figureFacet(String field) {
        return JsonTree.tree().put("terms", JsonTree.tree().put("field", field).put("size", JsonTree.ifPositive(this.query.getFacetLimit())).put("min_doc_count", JsonTree.ifPositive(this.query.getFacetMinCount()))).asMap();
    }

    private List<String> figureReturnFields() {
        return new ArrayList<String>(this.query.getFieldsToReturn());
    }

    private Map<String, Object> figureFullMap() {
        return JsonTree.tree().put("query", this.queryAndFilters).put("from", JsonTree.ifPositive(this.query.getStart())).put("highlight", this.highlighter).put("size", JsonTree.ifPositive(this.query.getRows())).put("sort", this.sortFields).put("_source", this.returnFields).put("aggregations", this.facets).asMap();
    }

    public String asString() throws SearchEngineException {
        try {
            return new ObjectMapper().writeValueAsString(this.fullMap);
        }
        catch (JsonProcessingException e) {
            throw new SearchEngineException(e);
        }
    }

    private static class QueryStringMap {
        public final Map<String, Object> map = new HashMap<String, Object>();

        public QueryStringMap(String queryString) {
            this.map.put("query_string", this.makeInnerMap(this.escape(queryString)));
        }

        private String escape(String queryString) {
            return queryString.replace(":", "\\:").replace("/", "\\/").replaceFirst("\\\\:", ":");
        }

        private Map<String, String> makeInnerMap(String queryString) {
            HashMap<String, String> inner = new HashMap<String, String>();
            inner.put("default_field", "ALLTEXT");
            inner.put("query", queryString);
            return inner;
        }
    }
}

