/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonTree {
    public static final Map<String, Object> EMPTY_JSON_MAP = Collections.emptyMap();
    public static final List<Object> EMPTY_JSON_LIST = Collections.emptyList();
    private Map<String, Object> map = new HashMap<String, Object>();

    public static JsonTree tree() {
        return new JsonTree();
    }

    public static Integer ifPositive(int i) {
        return i > 0 ? Integer.valueOf(i) : null;
    }

    public JsonTree put(String key, Object value) {
        if (this.isSignificant(value)) {
            this.storeIt(key, value);
        }
        return this;
    }

    private boolean isSignificant(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Map && ((Map)value).isEmpty() && value != EMPTY_JSON_MAP) {
            return false;
        }
        return !(value instanceof List) || !((List)value).isEmpty() || value == EMPTY_JSON_LIST;
    }

    private void storeIt(String key, Object value) {
        if (value instanceof JsonTree) {
            this.map.put(key, ((JsonTree)value).asMap());
        } else {
            this.map.put(key, value);
        }
    }

    public Map<String, Object> asMap() {
        return new HashMap<String, Object>(this.map);
    }
}

