/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch;

import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchQuery;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.ESAdder;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.ESCounter;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.ESDeleter;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.ESFlusher;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.ESQuery;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElasticSearchEngine
implements SearchEngine {
    private static final Log log = LogFactory.getLog(ElasticSearchEngine.class);
    private String baseUrl;

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasBaseUrl")
    public void setBaseUrl(String url) {
        if (this.baseUrl == null) {
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
        } else {
            throw new IllegalStateException("Configuration includes multiple base URLs: " + url + ", and " + this.baseUrl);
        }
        this.baseUrl = url;
    }

    @Validation
    public void validate() throws Exception {
        if (this.baseUrl == null) {
            throw new IllegalStateException("Configuration did not include a base URL.");
        }
    }

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        log.warn((Object)"ElasticSearchEngine.startup() not implemented.");
    }

    @Override
    public void shutdown(Application application) {
        log.warn((Object)"ElasticSearchEngine.shutdown not implemented.");
    }

    @Override
    public void ping() throws SearchEngineException {
        log.warn((Object)"ElasticSearchEngine.ping() not implemented.");
    }

    @Override
    public SearchInputDocument createInputDocument() {
        return new BaseSearchInputDocument();
    }

    @Override
    public void add(SearchInputDocument ... docs) throws SearchEngineException {
        this.add(Arrays.asList(docs));
    }

    @Override
    public void add(Collection<SearchInputDocument> docs) throws SearchEngineException {
        new ESAdder(this.baseUrl).add(docs);
    }

    @Override
    public void commit() throws SearchEngineException {
        new ESFlusher(this.baseUrl).flush();
    }

    @Override
    public void commit(boolean wait) throws SearchEngineException {
        new ESFlusher(this.baseUrl).flush(wait);
    }

    @Override
    public void deleteById(String ... ids) throws SearchEngineException {
        this.deleteById(Arrays.asList(ids));
    }

    @Override
    public void deleteById(Collection<String> ids) throws SearchEngineException {
        new ESDeleter(this.baseUrl).deleteByIds(ids);
    }

    @Override
    public void deleteByQuery(String query) throws SearchEngineException {
        new ESDeleter(this.baseUrl).deleteByQuery(query);
    }

    @Override
    public SearchQuery createQuery() {
        return new BaseSearchQuery();
    }

    @Override
    public SearchQuery createQuery(String queryText) {
        BaseSearchQuery query = new BaseSearchQuery();
        query.setQuery(queryText);
        return query;
    }

    @Override
    public SearchResponse query(SearchQuery query) throws SearchEngineException {
        return new ESQuery(this.baseUrl).query(query);
    }

    @Override
    public int documentCount() throws SearchEngineException {
        return new ESCounter(this.baseUrl).count();
    }
}

