/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateUrisInIndex {
    private static final Log log = LogFactory.getLog(UpdateUrisInIndex.class);
    public static final Pattern DELIMITER = Pattern.compile("[,\\s]+");

    protected int doUpdateUris(HttpServletRequest req, SearchIndexer indexer) throws ServletException, IOException {
        Map<String, List<FileItem>> map = new VitroRequest(req).getFiles();
        if (map == null) {
            throw new ServletException("Expected Multipart Content");
        }
        Charset enc = this.getEncoding(req);
        int uriCount = 0;
        for (String name : map.keySet()) {
            for (FileItem item : map.get(name)) {
                log.debug((Object)("Found " + item.getSize() + " byte file for '" + name + "'"));
                uriCount += this.processFileItem(indexer, item, enc);
            }
        }
        return uriCount;
    }

    private int processFileItem(SearchIndexer indexer, FileItem item, Charset enc) throws IOException {
        ArrayList<String> uris = new ArrayList<String>();
        InputStreamReader reader = new InputStreamReader(item.getInputStream(), enc.name());
        try (Scanner scanner = this.createScanner(reader);){
            while (scanner.hasNext()) {
                String uri = scanner.next();
                log.debug((Object)("Request to index uri '" + uri + "'"));
                uris.add(uri);
            }
        }
        indexer.scheduleUpdatesForUris(uris);
        return uris.size();
    }

    protected Scanner createScanner(Reader in) {
        return new Scanner(in).useDelimiter(DELIMITER);
    }

    private Charset getEncoding(HttpServletRequest req) {
        String enc = req.getCharacterEncoding();
        if (StringUtils.isBlank((CharSequence)enc)) {
            log.debug((Object)"No encoding on POST request, That is acceptable.");
            enc = "UTF-8";
        } else if (enc.length() > 30) {
            log.debug((Object)("Ignoring odd encoding of '" + enc + "'"));
            enc = "UTF-8";
        } else {
            log.debug((Object)("Encoding set on POST request: " + enc));
        }
        log.debug((Object)("Reading POSTed URIs with encoding " + enc));
        return Charset.forName(enc);
    }
}

