/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging.RDFServiceLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.RDFNode;

public class LoggingRDFService
implements RDFService {
    private final RDFService innerService;
    private VitroRequest vitroRequest;

    LoggingRDFService(RDFService innerService) {
        this.innerService = innerService;
    }

    @Override
    public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(changeSet);){
            boolean bl = this.innerService.changeSetUpdate(changeSet);
            return bl;
        }
    }

    @Override
    public InputStream sparqlConstructQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(new Object[]{resultFormat, query});){
            InputStream inputStream = this.innerService.sparqlConstructQuery(query, resultFormat);
            return inputStream;
        }
    }

    @Override
    public void sparqlConstructQuery(String query, Model model) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(query);){
            this.innerService.sparqlConstructQuery(query, model);
        }
    }

    @Override
    public InputStream sparqlDescribeQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(new Object[]{resultFormat, query});){
            InputStream inputStream = this.innerService.sparqlDescribeQuery(query, resultFormat);
            return inputStream;
        }
    }

    @Override
    public InputStream sparqlSelectQuery(String query, RDFService.ResultFormat resultFormat) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(new Object[]{resultFormat, query});){
            InputStream inputStream = this.innerService.sparqlSelectQuery(query, resultFormat);
            return inputStream;
        }
    }

    @Override
    public void sparqlSelectQuery(String query, ResultSetConsumer consumer) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(query);){
            this.innerService.sparqlSelectQuery(query, consumer);
        }
    }

    @Override
    public boolean sparqlAskQuery(String query) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(query);){
            boolean bl = this.innerService.sparqlAskQuery(query);
            return bl;
        }
    }

    @Override
    public void serializeAll(OutputStream outputStream) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(new Object[0]);){
            this.innerService.serializeAll(outputStream);
        }
    }

    @Override
    public void serializeGraph(String graphURI, OutputStream outputStream) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(graphURI);){
            this.innerService.serializeGraph(graphURI, outputStream);
        }
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(graphURI);){
            boolean bl = this.innerService.isEquivalentGraph(graphURI, serializedGraph, serializationFormat);
            return bl;
        }
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
        try (RDFServiceLogger l = new RDFServiceLogger(graphURI);){
            boolean bl = this.innerService.isEquivalentGraph(graphURI, graph);
            return bl;
        }
    }

    @Override
    public void newIndividual(String individualURI, String individualTypeURI) throws RDFServiceException {
        this.innerService.newIndividual(individualURI, individualTypeURI);
    }

    @Override
    public void newIndividual(String individualURI, String individualTypeURI, String graphURI) throws RDFServiceException {
        this.innerService.newIndividual(individualURI, individualTypeURI, graphURI);
    }

    @Override
    public List<String> getGraphURIs() throws RDFServiceException {
        return this.innerService.getGraphURIs();
    }

    @Override
    public void getGraphMetadata() throws RDFServiceException {
        this.innerService.getGraphMetadata();
    }

    @Override
    public String getDefaultWriteGraphURI() throws RDFServiceException {
        return this.innerService.getDefaultWriteGraphURI();
    }

    @Override
    public void registerListener(ChangeListener changeListener) throws RDFServiceException {
        this.innerService.registerListener(changeListener);
    }

    @Override
    public void unregisterListener(ChangeListener changeListener) throws RDFServiceException {
        this.innerService.unregisterListener(changeListener);
    }

    @Override
    public void registerJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.innerService.registerJenaModelChangedListener(changeListener);
    }

    @Override
    public void unregisterJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.innerService.unregisterJenaModelChangedListener(changeListener);
    }

    @Override
    public ChangeSet manufactureChangeSet() {
        return this.innerService.manufactureChangeSet();
    }

    @Override
    public long countTriples(RDFNode subject, RDFNode predicate, RDFNode object) throws RDFServiceException {
        return this.innerService.countTriples(subject, predicate, object);
    }

    @Override
    public Model getTriples(RDFNode subject, RDFNode predicate, RDFNode object, long limit, long offset) throws RDFServiceException {
        return this.innerService.getTriples(subject, predicate, object, limit, offset);
    }

    @Override
    public boolean preferPreciseOptionals() {
        return this.innerService.preferPreciseOptionals();
    }

    @Override
    public void close() {
        this.innerService.close();
    }

    public String toString() {
        return "LoggingRDFService[inner=" + this.innerService + "]";
    }

    @Override
    public void setVitroRequest(VitroRequest vitroRequest) {
        this.vitroRequest = vitroRequest;
    }

    @Override
    public VitroRequest getVitroRequest() {
        return this.vitroRequest;
    }
}

