/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaModelUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.ResultSetIterators;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sdb.SDB;

public abstract class RDFServiceJena
extends RDFServiceImpl
implements RDFService {
    private static final Log log = LogFactory.getLog(RDFServiceJena.class);
    protected volatile boolean rebuildGraphURICache = true;
    protected volatile boolean isRebuildGraphURICacheRunning = false;
    protected final List<String> graphURIs = Collections.synchronizedList(new ArrayList());
    private static final boolean CONSTRUCT = true;
    private static final boolean DESCRIBE = false;
    private VitroRequest vitroRequest;

    protected abstract DatasetWrapper getDatasetWrapper();

    @Override
    public abstract boolean changeSetUpdate(ChangeSet var1) throws RDFServiceException;

    protected void notifyListenersOfPreChangeEvents(ChangeSet changeSet) {
        for (Object o : changeSet.getPreChangeEvents()) {
            this.notifyListenersOfEvent(o);
        }
    }

    protected void insureThatInputStreamsAreResettable(ChangeSet changeSet) throws IOException {
        for (ModelChange modelChange : changeSet.getModelChanges()) {
            if (!modelChange.getSerializedModel().markSupported()) {
                byte[] bytes = IOUtils.toByteArray((InputStream)modelChange.getSerializedModel());
                modelChange.setSerializedModel(new ByteArrayInputStream(bytes));
            }
            modelChange.getSerializedModel().mark(Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyChangeSetToModel(ChangeSet changeSet, Dataset dataset) {
        for (ModelChange modelChange : changeSet.getModelChanges()) {
            dataset.getLock().enterCriticalSection(false);
            try {
                Model model = modelChange.getGraphURI() == null ? dataset.getDefaultModel() : dataset.getNamedModel(modelChange.getGraphURI());
                this.operateOnModel(model, modelChange);
            }
            finally {
                dataset.getLock().leaveCriticalSection();
            }
        }
    }

    protected void notifyListenersOfPostChangeEvents(ChangeSet changeSet) {
        for (Object o : changeSet.getPostChangeEvents()) {
            this.notifyListenersOfEvent(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void operateOnModel(Model model, ModelChange modelChange) {
        model.enterCriticalSection(false);
        try {
            if (log.isDebugEnabled()) {
                this.dumpOperation(model, modelChange);
            }
            if (modelChange.getOperation() == ModelChange.Operation.ADD) {
                Model addition = this.parseModel(modelChange);
                model.add(addition);
            } else if (modelChange.getOperation() == ModelChange.Operation.REMOVE) {
                Model removal = this.parseModel(modelChange);
                JenaModelUtils.removeWithBlankNodesAsVariables(removal, model);
            } else {
                log.error((Object)"unrecognized operation type");
            }
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    private void dumpOperation(Model model, ModelChange modelChange) {
        String op = String.valueOf((Object)modelChange.getOperation());
        byte[] changeBytes = new byte[]{};
        try {
            modelChange.getSerializedModel().mark(Integer.MAX_VALUE);
            changeBytes = IOUtils.toByteArray((InputStream)modelChange.getSerializedModel());
            modelChange.getSerializedModel().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int puncCount = 0;
        boolean inUri = false;
        boolean inQuotes = false;
        for (byte b : changeBytes) {
            if (inQuotes) {
                if (b != 34) continue;
                inQuotes = false;
                continue;
            }
            if (inUri) {
                if (b != 62) continue;
                inUri = false;
                continue;
            }
            if (b == 34) {
                inQuotes = true;
                continue;
            }
            if (b == 60) {
                inUri = true;
                continue;
            }
            if (b != 44 && b != 59 && b != 46) continue;
            ++puncCount;
        }
        String changeString = new String(changeBytes).replace('\n', ' ');
        log.debug((Object)String.format(">>>>OPERATION: %3.3s %03dpunc, format=%s, graphUri='%s'\n    start=%.200s\n    model=%s", new Object[]{modelChange.getOperation(), puncCount, modelChange.getSerializationFormat(), modelChange.getGraphURI(), changeString, ToString.modelToString(model)}));
    }

    private Model parseModel(ModelChange modelChange) {
        Model model = ModelFactory.createDefaultModel();
        model.read(modelChange.getSerializedModel(), null, RDFServiceJena.getSerializationFormatString(modelChange.getSerializationFormat()));
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getRDFResultStream(String query, boolean construct, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            ByteArrayInputStream byteArrayInputStream;
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            QueryExecution qe = this.createQueryExecution(query, q, d);
            ByteArrayOutputStream serializedModel = new ByteArrayOutputStream();
            try {
                ByteArrayInputStream result;
                Model m = construct ? qe.execConstruct() : qe.execDescribe();
                m.write((OutputStream)serializedModel, RDFServiceJena.getSerializationFormatString(resultFormat));
                byteArrayInputStream = result = new ByteArrayInputStream(serializedModel.toByteArray());
            }
            catch (Throwable throwable) {
                qe.close();
                throw throwable;
            }
            qe.close();
            return byteArrayInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRDFModel(String query, boolean construct, Model model) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            try (QueryExecution qe = this.createQueryExecution(query, q, d);){
                Model model2 = construct ? qe.execConstruct(model) : qe.execDescribe(model);
            }
        }
    }

    @Override
    public InputStream sparqlConstructQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        return this.getRDFResultStream(query, true, resultFormat);
    }

    @Override
    public void sparqlConstructQuery(String query, Model model) throws RDFServiceException {
        this.getRDFModel(query, true, model);
    }

    @Override
    public InputStream sparqlDescribeQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        return this.getRDFResultStream(query, false, resultFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlSelectQuery(String query, RDFService.ResultFormat resultFormat) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            ByteArrayInputStream byteArrayInputStream;
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            QueryExecution qe = this.createQueryExecution(query, q, d);
            try {
                ByteArrayInputStream result;
                ResultSet resultSet = qe.execSelect();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                switch (resultFormat) {
                    case CSV: {
                        ResultSetFormatter.outputAsCSV((OutputStream)outputStream, (ResultSet)resultSet);
                        break;
                    }
                    case TEXT: {
                        ResultSetFormatter.out((OutputStream)outputStream, (ResultSet)resultSet);
                        break;
                    }
                    case JSON: {
                        ResultSetFormatter.outputAsJSON((OutputStream)outputStream, (ResultSet)resultSet);
                        break;
                    }
                    case XML: {
                        ResultSetFormatter.outputAsXML((OutputStream)outputStream, (ResultSet)resultSet);
                        break;
                    }
                    default: {
                        throw new RDFServiceException("unrecognized result format");
                    }
                }
                byteArrayInputStream = result = new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (Throwable throwable) {
                qe.close();
                throw throwable;
            }
            qe.close();
            return byteArrayInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sparqlSelectQuery(String query, ResultSetConsumer consumer) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            try (QueryExecution qe = this.createQueryExecution(query, q, d);){
                consumer.processResultSet(qe.execSelect());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sparqlAskQuery(String query) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            boolean bl;
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            QueryExecution qe = this.createQueryExecution(query, q, d);
            try {
                bl = qe.execAsk();
            }
            catch (Throwable throwable) {
                qe.close();
                throw throwable;
            }
            qe.close();
            return bl;
        }
    }

    @Override
    public List<String> getGraphURIs() throws RDFServiceException {
        if (this.rebuildGraphURICache && !this.isRebuildGraphURICacheRunning) {
            this.rebuildGraphUris();
        }
        return this.graphURIs;
    }

    protected void rebuildGraphUris() {
        VitroBackgroundThread thread = new VitroBackgroundThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<RDFServiceJena> clazz = RDFServiceJena.class;
                synchronized (RDFServiceJena.class) {
                    if (RDFServiceJena.this.rebuildGraphURICache) {
                        DatasetWrapper dw = RDFServiceJena.this.getDatasetWrapper();
                        try {
                            RDFServiceJena.this.isRebuildGraphURICacheRunning = true;
                            Dataset d = dw.getDataset();
                            HashSet<String> newGraphUris = new HashSet<String>();
                            d.begin(ReadWrite.READ);
                            try {
                                Iterator nameIt = d.listNames();
                                while (nameIt.hasNext()) {
                                    newGraphUris.add((String)nameIt.next());
                                }
                            }
                            finally {
                                d.end();
                            }
                            HashSet<String> oldGraphUris = new HashSet<String>(RDFServiceJena.this.graphURIs);
                            if (newGraphUris.equals(oldGraphUris)) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                            HashSet<String> removedGraphUris = new HashSet<String>(oldGraphUris);
                            removedGraphUris.removeAll(newGraphUris);
                            RDFServiceJena.this.graphURIs.removeAll(removedGraphUris);
                            HashSet addedGraphUris = new HashSet(newGraphUris);
                            addedGraphUris.removeAll(oldGraphUris);
                            RDFServiceJena.this.graphURIs.addAll(addedGraphUris);
                        }
                        catch (Exception e) {
                            log.error((Object)e, (Throwable)e);
                        }
                        finally {
                            RDFServiceJena.this.isRebuildGraphURICacheRunning = false;
                            dw.close();
                            RDFServiceJena.this.rebuildGraphURICache = false;
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, "Rebuild graphURI cache thread");
        ((Thread)thread).start();
    }

    @Override
    public void getGraphMetadata() throws RDFServiceException {
    }

    @Override
    public void serializeAll(OutputStream outputStream) throws RDFServiceException {
        String query = "SELECT * WHERE { GRAPH ?g {?s ?p ?o}}";
        this.serialize(outputStream, query);
    }

    @Override
    public void serializeGraph(String graphURI, OutputStream outputStream) throws RDFServiceException {
        String query = "SELECT * WHERE { GRAPH <" + graphURI + "> {?s ?p ?o}}";
        this.serialize(outputStream, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(OutputStream outputStream, String query) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            QueryExecution qe = this.createQueryExecution(query, q, d);
            qe.getContext().set(SDB.jdbcFetchSize, (Object)Integer.MIN_VALUE);
            qe.getContext().set(SDB.jdbcStream, true);
            qe.getContext().set(SDB.streamGraphAPI, true);
            try {
                ResultSet resultSet = qe.execSelect();
                if (resultSet.getResultVars().contains("g")) {
                    ResultSetIterators.ResultSetQuadsIterator quads = new ResultSetIterators.ResultSetQuadsIterator(resultSet);
                    RDFDataMgr.writeQuads((OutputStream)outputStream, (Iterator)quads);
                } else {
                    ResultSetIterators.ResultSetTriplesIterator triples = new ResultSetIterators.ResultSetTriplesIterator(resultSet);
                    RDFDataMgr.writeTriples((OutputStream)outputStream, (Iterator)triples);
                }
            }
            finally {
                qe.close();
            }
        }
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
        Model fileModel = RDFServiceUtils.parseModel(serializedGraph, serializationFormat);
        Model tripleStoreModel = new RDFServiceDataset(this).getNamedModel(graphURI);
        Model fromTripleStoreModel = ModelFactory.createDefaultModel().add(tripleStoreModel);
        return fileModel.isIsomorphicWith(fromTripleStoreModel);
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
        Model tripleStoreModel = new RDFServiceDataset(this).getNamedModel(graphURI);
        Model fromTripleStoreModel = ModelFactory.createDefaultModel().add(tripleStoreModel);
        return graph.isIsomorphicWith(fromTripleStoreModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countTriples(RDFNode subject, RDFNode predicate, RDFNode object) throws RDFServiceException {
        Query countQuery = QueryFactory.create((String)"SELECT (COUNT(?s) AS ?count) WHERE { ?s ?p ?o } ORDER BY ?s ?p ?o", (Syntax)Syntax.syntaxSPARQL_11);
        QuerySolutionMap map = new QuerySolutionMap();
        if (subject != null) {
            map.add("s", subject);
        }
        if (predicate != null) {
            map.add("p", predicate);
        }
        if (object != null) {
            map.add("o", object);
        }
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)countQuery, (Dataset)d, (QuerySolution)map);){
                ResultSet results = qexec.execSelect();
                if (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    Literal literal = soln.getLiteral("count");
                    long l = literal.getLong();
                    return l;
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getTriples(RDFNode subject, RDFNode predicate, RDFNode object, long limit, long offset) throws RDFServiceException {
        Query query = QueryFactory.create((String)"CONSTRUCT WHERE { ?s ?p ?o }", (Syntax)Syntax.syntaxSPARQL_11);
        QuerySolutionMap map = new QuerySolutionMap();
        if (subject != null) {
            map.add("s", subject);
        }
        if (predicate != null) {
            map.add("p", predicate);
        }
        if (object != null) {
            map.add("o", object);
        }
        query.setOffset(offset);
        query.setLimit(limit);
        Model triples = ModelFactory.createDefaultModel();
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)d, (QuerySolution)map);){
                qexec.execConstruct(triples);
            }
            Model model = triples;
            return model;
        }
    }

    @Override
    public boolean preferPreciseOptionals() {
        return false;
    }

    @Override
    public void close() {
    }

    protected QueryExecution createQueryExecution(String queryString, Query q, Dataset d) {
        return QueryExecutionFactory.create((Query)q, (Dataset)d);
    }

    @Override
    public void setVitroRequest(VitroRequest vitroRequest) {
        this.vitroRequest = vitroRequest;
    }

    @Override
    public VitroRequest getVitroRequest() {
        return this.vitroRequest;
    }
}

