/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl;

import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.ModelChangeImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ChangeSetImpl
implements ChangeSet {
    private String preconditionQuery;
    private RDFService.SPARQLQueryType queryType;
    private ArrayList<ModelChange> modelChanges = new ArrayList();
    private ArrayList<Object> preChangeEvents = new ArrayList();
    private ArrayList<Object> postChangeEvents = new ArrayList();

    public ChangeSetImpl() {
        this.modelChanges = new ArrayList();
    }

    @Override
    public String getPreconditionQuery() {
        return this.preconditionQuery;
    }

    @Override
    public void setPreconditionQuery(String preconditionQuery) {
        this.preconditionQuery = preconditionQuery;
    }

    @Override
    public RDFService.SPARQLQueryType getPreconditionQueryType() {
        return this.queryType;
    }

    @Override
    public void setPreconditionQueryType(RDFService.SPARQLQueryType queryType) {
        this.queryType = queryType;
    }

    @Override
    public List<ModelChange> getModelChanges() {
        return this.modelChanges;
    }

    @Override
    public void addAddition(InputStream model, RDFService.ModelSerializationFormat format, String graphURI) {
        this.modelChanges.add(this.manufactureModelChange(model, format, ModelChange.Operation.ADD, graphURI));
    }

    @Override
    public void addRemoval(InputStream model, RDFService.ModelSerializationFormat format, String graphURI) {
        this.modelChanges.add(this.manufactureModelChange(model, format, ModelChange.Operation.REMOVE, graphURI));
    }

    @Override
    public ModelChange manufactureModelChange() {
        return new ModelChangeImpl();
    }

    @Override
    public ModelChange manufactureModelChange(InputStream serializedModel, RDFService.ModelSerializationFormat serializationFormat, ModelChange.Operation operation, String graphURI) {
        return new ModelChangeImpl(serializedModel, serializationFormat, operation, graphURI);
    }

    @Override
    public void addPreChangeEvent(Object o) {
        this.preChangeEvents.add(o);
    }

    @Override
    public void addPostChangeEvent(Object o) {
        this.postChangeEvents.add(o);
    }

    @Override
    public List<Object> getPreChangeEvents() {
        return this.preChangeEvents;
    }

    @Override
    public List<Object> getPostChangeEvents() {
        return this.postChangeEvents;
    }

    public String toString() {
        return "ChangeSetImpl [preconditionQuery=" + this.preconditionQuery + ", queryType=" + (Object)((Object)this.queryType) + ", modelChanges=" + this.modelChanges + ", preChangeEvents=" + this.preChangeEvents + ", postChangeEvents=" + this.postChangeEvents + "]";
    }
}

