/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.AcceptableLanguages;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringGraph;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class LanguageFilteringUtils {
    private static final String UNDERSCORE = "_";
    private static final String HYPHEN = "-";
    private static final String DEFAULT_LANG_STRING = "en";

    public static String localeToLanguage(Locale locale) {
        return locale.toLanguageTag().replace(UNDERSCORE, HYPHEN);
    }

    public static Locale languageToLocale(String langStr) {
        String[] langParts = langStr.split(HYPHEN);
        langStr = langParts.length > 2 ? String.join((CharSequence)UNDERSCORE, langParts[0].toLowerCase(), langParts[1].toUpperCase(), langParts[2]) : (langParts.length > 1 ? String.join((CharSequence)UNDERSCORE, langParts[0].toLowerCase(), langParts[1].toUpperCase()) : langParts[0].toLowerCase());
        return LocaleUtils.toLocale((String)langStr);
    }

    public static List<String> localesToLanguages(Enumeration<?> locales) {
        ArrayList<String> langs = new ArrayList<String>();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            langs.add(locale.toLanguageTag().replace(UNDERSCORE, HYPHEN));
        }
        if (!langs.contains(DEFAULT_LANG_STRING)) {
            langs.add(DEFAULT_LANG_STRING);
        }
        return langs;
    }

    public static List<Locale> languagesToLocales(List<String> langs) {
        HashSet<Locale> locales = new HashSet<Locale>();
        langs.forEach(langStr -> locales.add(LanguageFilteringUtils.languageToLocale(langStr)));
        if (locales.isEmpty()) {
            locales.add(LocaleUtils.toLocale((String)DEFAULT_LANG_STRING));
        }
        return new ArrayList<Locale>(locales);
    }

    public static OntModel wrapOntModelInALanguageFilter(OntModel rawModel, ServletRequest req) {
        AcceptableLanguages languages = new AcceptableLanguages(LanguageFilteringUtils.localesToLanguages(req.getLocales()));
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)ModelFactory.createModelForGraph((Graph)new LanguageFilteringGraph(rawModel.getGraph(), languages)));
    }

    private LanguageFilteringUtils() {
    }
}

