/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcceptableLanguages
extends ArrayList<String> {
    private static final String SEPARATOR = "-";
    private static final String PRIVATE_USE_SUBTAG = "x";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AcceptableLanguages.class);

    public AcceptableLanguages(List<String> rawLanguageStrs) {
        log.debug((Object)("Raw language strings:" + rawLanguageStrs));
        for (String lang : rawLanguageStrs) {
            this.add(lang);
            String[] subtags = lang.split(SEPARATOR);
            int length = subtags.length;
            for (int i = 1; i < length; ++i) {
                String baseLang;
                int lastIndex = length - i;
                if (PRIVATE_USE_SUBTAG.equals(subtags[lastIndex - 1]) || lang.equals(baseLang = String.join((CharSequence)SEPARATOR, Arrays.copyOfRange(subtags, 0, lastIndex))) || this.contains(baseLang)) continue;
                this.add(baseLang);
            }
        }
        log.debug((Object)("Normalized language strings:" + this));
    }
}

