/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelMaker;

public class ModelMakerOntModelCache
implements OntModelCache {
    private final Map<String, OntModel> cache = new HashMap<String, OntModel>();
    private final ModelMaker mm;

    public ModelMakerOntModelCache(ModelMaker mm) {
        this.mm = mm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntModel getOntModel(String name) {
        Map<String, OntModel> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(name)) {
                return this.cache.get(name);
            }
            return this.wrapAndCache(name);
        }
    }

    private OntModel wrapAndCache(String name) {
        Model m = this.mm.getModel(name);
        OntModel om = VitroModelFactory.createOntologyModel(m);
        this.cache.put(name, om);
        return om;
    }

    @Override
    public SortedSet<String> getModelNames() {
        return new TreeSet<String>(this.mm.listModels().toList());
    }

    public String toString() {
        return "ModelMakerOntModelCache[" + ToString.hashHex(this) + ", mm=" + this.mm + "]";
    }
}

