/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;

public class JoinedOntModelCache
implements OntModelCache {
    private static final Log log = LogFactory.getLog(JoinedOntModelCache.class);
    private final OntModelCache primary;
    private final OntModelCache secondary;

    public JoinedOntModelCache(OntModelCache primary, OntModelCache secondary) {
        this.primary = primary;
        this.secondary = secondary;
        HashSet<String> duplicateNames = new HashSet<String>(primary.getModelNames());
        duplicateNames.retainAll(secondary.getModelNames());
        if (!duplicateNames.isEmpty()) {
            log.warn((Object)("These model names appear in both caches: " + duplicateNames));
        }
    }

    @Override
    public OntModel getOntModel(String name) {
        if (this.primary.getModelNames().contains(name)) {
            return this.primary.getOntModel(name);
        }
        if (this.secondary.getModelNames().contains(name)) {
            return this.secondary.getOntModel(name);
        }
        return this.primary.getOntModel(name);
    }

    @Override
    public SortedSet<String> getModelNames() {
        TreeSet<String> allNames = new TreeSet<String>(this.primary.getModelNames());
        allNames.addAll(this.secondary.getModelNames());
        return allNames;
    }

    public String toString() {
        return "JoinedOntModelCache[" + ToString.hashHex(this) + ", primary=" + this.primary + ", secondary=" + this.secondary + "]";
    }
}

