/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.impl;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryConfig;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelectorImpl;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactorySDB;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.triplesource.CombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.ModelMaker;

public class ContextModelAccessImpl
implements ContextModelAccess {
    private static final Log log = LogFactory.getLog(ContextModelAccessImpl.class);
    private static final String VITRO_DEFAULT_NAMESPACE = "Vitro.defaultNamespace";
    private final ConfigurationProperties props;
    private final CombinedTripleSource factory;
    private final Map<ModelAccess.WhichService, RDFService> rdfServiceMap;
    private final Map<ModelAccess.WhichService, Dataset> datasetMap;
    private final Map<ModelAccess.WhichService, ModelMaker> modelMakerMap;
    private final OntModelCache ontModelCache;
    private final Map<ModelAccess.ReasoningOption, OntModelSelector> omsMap;
    private final Map<ModelAccess.ReasoningOption, WebappDaoFactory> wadfMap;

    public ContextModelAccessImpl(ServletContext ctx, CombinedTripleSource factory) {
        this.props = ConfigurationProperties.getBean(ctx);
        this.factory = factory;
        this.ontModelCache = factory.getOntModelCache();
        this.rdfServiceMap = this.populateRdfServiceMap();
        this.datasetMap = this.populateDatasetMap();
        this.modelMakerMap = this.populateModelMakerMap();
        this.omsMap = this.populateOmsMap();
        this.wadfMap = this.populateWadfMap();
    }

    public String toString() {
        return "ContextModelAccessImpl[" + ToString.hashHex(this) + ", factory=" + this.factory + "]";
    }

    private Map<ModelAccess.WhichService, RDFService> populateRdfServiceMap() {
        EnumMap<ModelAccess.WhichService, RDFService> map = new EnumMap<ModelAccess.WhichService, RDFService>(ModelAccess.WhichService.class);
        map.put(ModelAccess.WhichService.CONTENT, this.factory.getRDFService(ModelAccess.WhichService.CONTENT));
        map.put(ModelAccess.WhichService.CONFIGURATION, this.factory.getRDFService(ModelAccess.WhichService.CONFIGURATION));
        log.debug((Object)("RdfServiceMap: " + map));
        return Collections.unmodifiableMap(map);
    }

    @Override
    public RDFService getRDFService() {
        return this.getRDFService(ModelAccess.WhichService.CONTENT);
    }

    @Override
    public RDFService getRDFService(ModelAccess.WhichService which) {
        RDFService rdfService = this.rdfServiceMap.get(which);
        log.debug((Object)("getRDFService " + which + ": " + rdfService));
        return rdfService;
    }

    private Map<ModelAccess.WhichService, Dataset> populateDatasetMap() {
        EnumMap<ModelAccess.WhichService, Dataset> map = new EnumMap<ModelAccess.WhichService, Dataset>(ModelAccess.WhichService.class);
        map.put(ModelAccess.WhichService.CONTENT, this.factory.getDataset(ModelAccess.WhichService.CONTENT));
        map.put(ModelAccess.WhichService.CONFIGURATION, this.factory.getDataset(ModelAccess.WhichService.CONFIGURATION));
        log.debug((Object)("DatasetMap: " + map));
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Dataset getDataset() {
        return this.getDataset(ModelAccess.WhichService.CONTENT);
    }

    @Override
    public Dataset getDataset(ModelAccess.WhichService which) {
        Dataset dataset = this.datasetMap.get(which);
        log.debug((Object)("getDataset " + which + ": " + dataset));
        return dataset;
    }

    private Map<ModelAccess.WhichService, ModelMaker> populateModelMakerMap() {
        EnumMap<ModelAccess.WhichService, ModelMaker> map = new EnumMap<ModelAccess.WhichService, ModelMaker>(ModelAccess.WhichService.class);
        map.put(ModelAccess.WhichService.CONTENT, this.factory.getModelMaker(ModelAccess.WhichService.CONTENT));
        map.put(ModelAccess.WhichService.CONFIGURATION, this.factory.getModelMaker(ModelAccess.WhichService.CONFIGURATION));
        log.debug((Object)("ModelMakerMap: " + map));
        return Collections.unmodifiableMap(map);
    }

    @Override
    public ModelMaker getModelMaker() {
        return this.getModelMaker(ModelAccess.WhichService.CONTENT);
    }

    @Override
    public ModelMaker getModelMaker(ModelAccess.WhichService which) {
        ModelMaker modelMaker = this.modelMakerMap.get(which);
        log.debug((Object)("getModelMaker " + which + ": " + modelMaker));
        return modelMaker;
    }

    @Override
    public OntModel getOntModel() {
        return this.getOntModel("vitro:jenaOntModel");
    }

    @Override
    public OntModel getOntModel(String name) {
        OntModel ontModel = this.ontModelCache.getOntModel(name);
        log.debug((Object)("getOntModel: " + name));
        return ontModel;
    }

    private Map<ModelAccess.ReasoningOption, OntModelSelector> populateOmsMap() {
        EnumMap<ModelAccess.ReasoningOption, OntModelSelector> map = new EnumMap<ModelAccess.ReasoningOption, OntModelSelector>(ModelAccess.ReasoningOption.class);
        map.put(ModelAccess.ReasoningOption.ASSERTIONS_ONLY, this.createOntModelSelector("http://vitro.mannlib.cornell.edu/default/vitro-kb-2", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", "vitro:baseOntModel"));
        map.put(ModelAccess.ReasoningOption.INFERENCES_ONLY, this.createOntModelSelector("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf", "http://vitro.mannlib.cornell.edu/default/inferred-tbox", "vitro:inferenceOntModel"));
        map.put(ModelAccess.ReasoningOption.ASSERTIONS_AND_INFERENCES, this.createOntModelSelector("vitro:aboxOntModel", "vitro:tboxOntModel", "vitro:jenaOntModel"));
        log.debug((Object)("OntModelSelectorMap: " + map));
        return Collections.unmodifiableMap(map);
    }

    private OntModelSelector createOntModelSelector(String aboxName, String tboxName, String fullName) {
        OntModelSelectorImpl oms = new OntModelSelectorImpl();
        oms.setABoxModel(this.getOntModel(aboxName));
        oms.setTBoxModel(this.getOntModel(tboxName));
        oms.setFullModel(this.getOntModel(fullName));
        oms.setApplicationMetadataModel(this.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata"));
        oms.setDisplayModel(this.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata"));
        oms.setUserAccountsModel(this.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts"));
        return oms;
    }

    @Override
    public OntModelSelector getOntModelSelector() {
        return this.getOntModelSelector(ModelAccess.ReasoningOption.ASSERTIONS_AND_INFERENCES);
    }

    @Override
    public OntModelSelector getOntModelSelector(ModelAccess.ReasoningOption option) {
        OntModelSelector ontModelSelector = this.omsMap.get(option);
        log.debug((Object)("getOntModelSelector: " + ontModelSelector));
        return ontModelSelector;
    }

    private Map<ModelAccess.ReasoningOption, WebappDaoFactory> populateWadfMap() {
        WebappDaoFactoryConfig config = new WebappDaoFactoryConfig();
        config.setDefaultNamespace(this.getDefaultNamespace());
        RDFService rdfService = this.getRDFService(ModelAccess.WhichService.CONTENT);
        EnumMap<ModelAccess.ReasoningOption, WebappDaoFactorySDB> map = new EnumMap<ModelAccess.ReasoningOption, WebappDaoFactorySDB>(ModelAccess.ReasoningOption.class);
        map.put(ModelAccess.ReasoningOption.ASSERTIONS_ONLY, new WebappDaoFactorySDB(rdfService, this.getOntModelSelector(ModelAccess.ReasoningOption.ASSERTIONS_ONLY), config, WebappDaoFactorySDB.SDBDatasetMode.ASSERTIONS_ONLY));
        map.put(ModelAccess.ReasoningOption.INFERENCES_ONLY, new WebappDaoFactorySDB(rdfService, this.getOntModelSelector(ModelAccess.ReasoningOption.INFERENCES_ONLY), config, WebappDaoFactorySDB.SDBDatasetMode.INFERENCES_ONLY));
        map.put(ModelAccess.ReasoningOption.ASSERTIONS_AND_INFERENCES, new WebappDaoFactorySDB(rdfService, this.getOntModelSelector(ModelAccess.ReasoningOption.ASSERTIONS_AND_INFERENCES), config, WebappDaoFactorySDB.SDBDatasetMode.ASSERTIONS_AND_INFERENCES));
        log.debug((Object)("WebappdaoFactoryMap: " + map));
        return Collections.unmodifiableMap(map);
    }

    private String getDefaultNamespace() {
        return this.props.getProperty(VITRO_DEFAULT_NAMESPACE);
    }

    @Override
    public WebappDaoFactory getWebappDaoFactory() {
        return this.getWebappDaoFactory(ModelAccess.ReasoningOption.ASSERTIONS_AND_INFERENCES);
    }

    @Override
    public WebappDaoFactory getWebappDaoFactory(ModelAccess.ReasoningOption option) {
        WebappDaoFactory wadf = this.wadfMap.get(option);
        log.debug((Object)("getWebappDaoFactory: " + wadf));
        return wadf;
    }
}

