/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.selection;

import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebFilter(filterName="Locale selection filter", urlPatterns={"/*"})
public class LocaleSelectionFilter
implements Filter {
    private static final Log log = LogFactory.getLog(LocaleSelectionFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hreq = (HttpServletRequest)request;
            Locale overridingLocale = SelectedLocale.getOverridingLocale(hreq);
            log.debug((Object)("overriding Locale is " + overridingLocale));
            if (overridingLocale != null) {
                request = new LocaleSelectionRequestWrapper(hreq, overridingLocale);
            }
        } else {
            log.debug((Object)"Not an HttpServletRequest.");
        }
        chain.doFilter(request, response);
    }

    private static class LocaleSelectionRequestWrapper
    extends HttpServletRequestWrapper {
        private final Locale selectedLocale;

        public LocaleSelectionRequestWrapper(HttpServletRequest request, Locale selectedLocale) {
            super(request);
            if (request == null) {
                throw new NullPointerException("request may not be null.");
            }
            if (selectedLocale == null) {
                throw new NullPointerException("selectedLocale may not be null.");
            }
            this.selectedLocale = selectedLocale;
        }

        public Locale getLocale() {
            return this.selectedLocale;
        }

        public Enumeration getLocales() {
            return Collections.enumeration(Arrays.asList(this.selectedLocale));
        }
    }
}

