/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.freemarker.config;

import edu.cornell.mannlib.vitro.webapp.config.RevisionInfoBean;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.DelimitingTemplateLoader;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.EditConfigurationConstants;
import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfigurationImpl;
import edu.cornell.mannlib.vitro.webapp.freemarker.loader.FreemarkerTemplateLoader;
import edu.cornell.mannlib.vitro.webapp.i18n.freemarker.I18nMethodModel;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import edu.cornell.mannlib.vitro.webapp.web.directives.IndividualShortViewDirective;
import edu.cornell.mannlib.vitro.webapp.web.directives.UrlDirective;
import edu.cornell.mannlib.vitro.webapp.web.directives.WidgetDirective;
import edu.cornell.mannlib.vitro.webapp.web.methods.IndividualLocalNameMethod;
import edu.cornell.mannlib.vitro.webapp.web.methods.IndividualPlaceholderImageUrlMethod;
import edu.cornell.mannlib.vitro.webapp.web.methods.IndividualProfileUrlMethod;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.dump.DumpAllDirective;
import freemarker.ext.dump.DumpDirective;
import freemarker.ext.dump.HelpDirective;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FreemarkerConfiguration {
    private static final Log log = LogFactory.getLog(FreemarkerConfiguration.class);
    private static volatile FreemarkerConfigurationImpl instance;
    private static volatile String previousThemeDir;
    private static volatile Map<String, Object> previousSettingsMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfig(HttpServletRequest req) {
        FreemarkerConfiguration.confirmInstanceIsSet();
        FreemarkerConfigurationImpl freemarkerConfigurationImpl = instance;
        synchronized (freemarkerConfigurationImpl) {
            FreemarkerConfiguration.clearTemplateCacheIfRequested();
            FreemarkerConfiguration.keepTemplateLoaderCurrentWithThemeDirectory(req);
            FreemarkerConfiguration.setThreadLocalsForRequest(req);
            return instance;
        }
    }

    private static void confirmInstanceIsSet() {
        if (instance == null) {
            throw new IllegalStateException("VitroFreemarkerConfiguration has not been set.");
        }
    }

    private static void clearTemplateCacheIfRequested() {
        DeveloperSettings settings = DeveloperSettings.getInstance();
        if (settings.getBoolean(Key.DEFEAT_FREEMARKER_CACHE)) {
            instance.clearTemplateCache();
        }
    }

    private static void keepTemplateLoaderCurrentWithThemeDirectory(HttpServletRequest req) {
        String themeDir = FreemarkerConfiguration.getThemeDirectory(req);
        if (FreemarkerConfiguration.hasThemeDirectoryChanged(themeDir) || FreemarkerConfiguration.haveDeveloperSettingsChanged()) {
            TemplateLoader tl = FreemarkerConfiguration.createTemplateLoader(req, themeDir);
            instance.setTemplateLoader(tl);
        }
    }

    private static String getThemeDirectory(HttpServletRequest req) {
        return new VitroRequest(req).getAppBean().getThemeDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasThemeDirectoryChanged(String themeDir) {
        FreemarkerConfigurationImpl freemarkerConfigurationImpl = instance;
        synchronized (freemarkerConfigurationImpl) {
            if (StringUtils.equals((CharSequence)themeDir, (CharSequence)previousThemeDir)) {
                return false;
            }
            previousThemeDir = themeDir;
            return true;
        }
    }

    private static boolean haveDeveloperSettingsChanged() {
        Map<String, Object> settingsMap = DeveloperSettings.getInstance().getRawSettingsMap();
        if (settingsMap.equals(previousSettingsMap)) {
            return false;
        }
        previousSettingsMap = settingsMap;
        return true;
    }

    private static TemplateLoader createTemplateLoader(HttpServletRequest req, String themeDir) {
        ServletContext ctx = req.getSession().getServletContext();
        ArrayList<FreemarkerTemplateLoader> loaders = new ArrayList<FreemarkerTemplateLoader>();
        String themeTemplatePath = ctx.getRealPath("/" + themeDir) + "/templates";
        File themeTemplateDir = new File(themeTemplatePath);
        if (themeTemplateDir.exists()) {
            loaders.add(new FreemarkerTemplateLoader(themeTemplateDir));
        }
        String vitroTemplatePath = ctx.getRealPath("/templates/freemarker");
        loaders.add(new FreemarkerTemplateLoader(new File(vitroTemplatePath)));
        loaders.add((FreemarkerTemplateLoader)new ClassTemplateLoader(FreemarkerConfiguration.class, ""));
        TemplateLoader[] loaderArray = loaders.toArray(new TemplateLoader[loaders.size()]);
        Object tl = new MultiTemplateLoader(loaderArray);
        DeveloperSettings settings = DeveloperSettings.getInstance();
        if (settings.getBoolean(Key.INSERT_FREEMARKER_DELIMITERS)) {
            tl = new DelimitingTemplateLoader((TemplateLoader)tl);
        }
        return tl;
    }

    private static void setThreadLocalsForRequest(HttpServletRequest req) {
        instance.setRequestInfo(req);
    }

    public static class Setup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            StartupStatus ss = StartupStatus.getBean(ctx);
            try {
                instance = this.createConfiguration(ctx);
                ss.info(this, "Initialized the Freemarker configuration.");
            }
            catch (Exception e) {
                ss.fatal(this, "Failed to initialize the Freemarker configuration.", e);
            }
        }

        private FreemarkerConfigurationImpl createConfiguration(ServletContext ctx) throws TemplateModelException {
            FreemarkerConfigurationImpl c = new FreemarkerConfigurationImpl();
            this.setMiscellaneousProperties(c);
            this.setSharedVariables(c, ctx);
            this.addDirectives(c);
            this.addMethods(c);
            return c;
        }

        private void setMiscellaneousProperties(FreemarkerConfigurationImpl c) {
            c.setTemplateUpdateDelay(60);
            DefaultObjectWrapper wrapper = new DefaultObjectWrapper();
            wrapper.setExposureLevel(2);
            c.setObjectWrapper((ObjectWrapper)wrapper);
            c.setLocale(Locale.US);
            String dateFormat = "M/d/yyyy";
            c.setDateFormat(dateFormat);
            String timeFormat = "h:mm a";
            c.setTimeFormat(timeFormat);
            c.setDateTimeFormat(dateFormat + " " + timeFormat);
            try {
                c.setSetting("url_escaping_charset", "UTF-8");
            }
            catch (TemplateException e) {
                log.error((Object)"Error setting value for url_escaping_charset.");
            }
        }

        private void setSharedVariables(FreemarkerConfigurationImpl c, ServletContext ctx) throws TemplateModelException {
            c.setSharedVariable("version", this.getRevisionInfo(ctx));
            c.setSharedVariable("editConfigurationConstants", EditConfigurationConstants.exportConstants());
        }

        private void addDirectives(FreemarkerConfigurationImpl c) {
            c.setSharedVariable("dump", (TemplateModel)new DumpDirective());
            c.setSharedVariable("dumpAll", (TemplateModel)new DumpAllDirective());
            c.setSharedVariable("help", (TemplateModel)new HelpDirective());
            c.setSharedVariable("shortView", (TemplateModel)new IndividualShortViewDirective());
            c.setSharedVariable("url", (TemplateModel)new UrlDirective());
            c.setSharedVariable("widget", (TemplateModel)new WidgetDirective());
        }

        private void addMethods(FreemarkerConfigurationImpl c) {
            c.setSharedVariable("profileUrl", (TemplateModel)new IndividualProfileUrlMethod());
            c.setSharedVariable("localName", (TemplateModel)new IndividualLocalNameMethod());
            c.setSharedVariable("placeholderImageUrl", (TemplateModel)new IndividualPlaceholderImageUrlMethod());
            c.setSharedVariable("i18n", (TemplateModel)new I18nMethodModel());
        }

        private Map<String, Object> getRevisionInfo(ServletContext ctx) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("label", RevisionInfoBean.getBean(ctx).getReleaseLabel());
            map.put("moreInfoUrl", UrlBuilder.getUrl("/revisionInfo"));
            return map;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            instance = null;
        }
    }
}

