/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.FileInfo;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileStorage;
import java.io.IOException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TempFileHolder
implements HttpSessionBindingListener {
    private static final Log log = LogFactory.getLog(TempFileHolder.class);
    private FileInfo fileInfo;

    public static void attach(HttpSession session, String attributeName, FileInfo fileInfo) {
        if (session == null) {
            throw new NullPointerException("session may not be null.");
        }
        if (attributeName == null) {
            throw new NullPointerException("attributeName may not be null.");
        }
        if (fileInfo == null) {
            throw new NullPointerException("fileInfo may not be null.");
        }
        log.debug((Object)("attach this file: " + fileInfo));
        session.setAttribute(attributeName, (Object)new TempFileHolder(fileInfo));
    }

    public static FileInfo remove(HttpSession session, String attributeName) {
        if (session == null) {
            throw new NullPointerException("session may not be null.");
        }
        if (attributeName == null) {
            throw new NullPointerException("attributeName may not be null.");
        }
        Object attribute = session.getAttribute(attributeName);
        if (attribute instanceof TempFileHolder) {
            FileInfo fileInfo = ((TempFileHolder)attribute).extractFileInfo();
            session.removeAttribute(attributeName);
            log.debug((Object)("remove this file: " + fileInfo));
            return fileInfo;
        }
        if (attribute == null) {
            return null;
        }
        session.removeAttribute(attributeName);
        return null;
    }

    private TempFileHolder(FileInfo fileInfo) {
        if (fileInfo == null) {
            throw new NullPointerException("fileInfo may not be null.");
        }
        this.fileInfo = fileInfo;
    }

    private FileInfo extractFileInfo() {
        FileInfo result = this.fileInfo;
        this.fileInfo = null;
        return result;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this.fileInfo == null) {
            log.trace((Object)"No file info.");
            return;
        }
        if (this.fileInfo.getBytestreamUri() == null) {
            log.warn((Object)"File info has no URI?");
            return;
        }
        FileStorage fs = ApplicationUtils.instance().getFileStorage();
        try {
            fs.deleteFile(this.fileInfo.getBytestreamUri());
            log.debug((Object)("Deleted file " + this.fileInfo));
        }
        catch (IOException e) {
            log.error((Object)("Failed to delete temp file from session: " + event), (Throwable)e);
        }
    }
}

