/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.controller;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractObjectPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.DropObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.DirectRedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.edit.EditConfigurationTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.edit.MultiValueEditSubmissionTemplateModel;
import java.util.HashMap;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.vocabulary.RDFS;

@WebServlet(name="EditRequestDispatch", urlPatterns={"/editRequestDispatch"})
public class EditRequestDispatchController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    public static Log log = LogFactory.getLog(EditRequestDispatchController.class);
    final String DEFAULT_OBJ_FORM = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultObjectPropertyFormGenerator";
    final String DEFAULT_DATA_FORM = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultDataPropertyFormGenerator";
    final String RDFS_LABEL_FORM = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.RDFSLabelGenerator";
    final String DEFAULT_DELETE_FORM = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultDeleteGenerator";
    final String MANAGE_MENUS_FORM = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.ManagePageGenerator";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        if (this.isIndividualDeletion(vreq)) {
            return SimplePermission.DO_BACK_END_EDITING.ACTION;
        }
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        String domainUri = EditConfigurationUtils.getDomainUri(vreq);
        String rangeUri = EditConfigurationUtils.getRangeUri(vreq);
        Property predicateProp = new Property();
        predicateProp.setURI(predicateUri);
        predicateProp.setDomainVClassURI(domainUri);
        predicateProp.setRangeVClassURI(rangeUri);
        OntModel ontModel = ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]);
        AbstractObjectPropertyStatementAction objectPropertyAction = StringUtils.isBlank((CharSequence)objectUri) ? new AddObjectPropertyStatement(ontModel, subjectUri, predicateProp, RequestedAction.SOME_URI) : (this.isDeleteForm(vreq) ? new DropObjectPropertyStatement(ontModel, subjectUri, predicateProp, objectUri) : new EditObjectPropertyStatement(ontModel, subjectUri, predicateProp, objectUri));
        boolean isAuthorized = PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{new EditDataPropertyStatement(ontModel, subjectUri, predicateUri, objectUri).or(objectPropertyAction)});
        if (!isAuthorized) {
            if (StringUtils.isNotEmpty((CharSequence)EditConfigurationUtils.getTypeOfNew(vreq))) {
                return SimplePermission.DO_BACK_END_EDITING.ACTION;
            }
            if ("edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.ManagePageGenerator".equals(vreq.getParameter("editForm"))) {
                return SimplePermission.MANAGE_MENUS.ACTION;
            }
        }
        return isAuthorized ? SimplePermission.DO_FRONT_END_EDITING.ACTION : AuthorizationRequest.UNAUTHORIZED;
    }

    private boolean isIndividualDeletion(VitroRequest vreq) {
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        return objectUri != null && subjectUri == null && predicateUri == null && this.isDeleteForm(vreq);
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        try {
            WebappDaoFactory wdf = vreq.getWebappDaoFactory();
            if (this.isMenuMode(vreq)) {
                return this.redirectToMenuEdit(vreq);
            }
            if (this.isErrorCondition(vreq)) {
                return this.doHelp(vreq, this.getErrorMessage(vreq));
            }
            if (this.isSkipPredicate(vreq)) {
                log.debug((Object)"The predicate is a annotated as a skip.");
                return this.processSkipEditForm(vreq);
            }
            String editConfGeneratorName = this.processEditConfGeneratorName(vreq);
            this.setSessionRequestFromEntity(vreq);
            EditConfigurationVTwo editConfig = this.setupEditConfiguration(editConfGeneratorName, vreq);
            log.debug((Object)("editConfiguration:\n" + editConfig));
            if (editConfig.getSkipToUrl() != null) {
                return new DirectRedirectResponseValues(editConfig.getSkipToUrl());
            }
            String template = editConfig.getTemplate();
            MultiValueEditSubmission submission = this.getMultiValueSubmission(vreq, editConfig);
            MultiValueEditSubmissionTemplateModel submissionTemplateModel = new MultiValueEditSubmissionTemplateModel(submission);
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            EditConfigurationTemplateModel etm = new EditConfigurationTemplateModel(editConfig, vreq);
            templateData.put("editConfiguration", etm);
            templateData.put("editSubmission", submissionTemplateModel);
            templateData.put("title", etm.getPageTitle());
            templateData.put("submitUrl", this.getSubmissionUrl(vreq));
            templateData.put("cancelUrl", etm.getCancelUrl());
            templateData.put("editKey", editConfig.getEditKey());
            templateData.put("bodyClasses", "formsEdit");
            return new TemplateResponseValues(template, templateData);
        }
        catch (Throwable th) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("errorMessage", th.toString());
            log.error((Object)th, th);
            return new TemplateResponseValues("error-message.ftl", map);
        }
    }

    private boolean isMenuMode(VitroRequest vreq) {
        return false;
    }

    private ResponseValues redirectToMenuEdit(VitroRequest vreq) {
        throw new RuntimeException("The EditRequestDispatchController cannot hijackall edits to the display model and force them into /editDisplayModel . Consider changing URLs used on special menu form to point to /editDisplayModel");
    }

    private MultiValueEditSubmission getMultiValueSubmission(VitroRequest vreq, EditConfigurationVTwo editConfig) {
        return EditSubmissionUtils.getEditSubmissionFromSession(vreq.getSession(), editConfig);
    }

    private EditConfigurationVTwo setupEditConfiguration(String editConfGeneratorName, VitroRequest vreq) throws Exception {
        HttpSession session = vreq.getSession();
        EditConfigurationVTwo editConfig = null;
        EditConfigurationVTwo existingConfig = EditConfigurationVTwo.getConfigFromSession(session, (HttpServletRequest)vreq);
        editConfig = existingConfig != null && !this.isDeleteForm(vreq) ? existingConfig : this.makeEditConfigurationVTwo(editConfGeneratorName, vreq, session);
        if (editConfig == null) {
            log.error((Object)"editConfig is null! How did this happen?");
        }
        String editKey = EditConfigurationUtils.getEditKey(vreq);
        editConfig.setEditKey(editKey);
        EditConfigurationVTwo.putConfigInSession(editConfig, session);
        return editConfig;
    }

    private void setSessionRequestFromEntity(VitroRequest vreq) {
        HttpSession session = vreq.getSession();
        String subjectUri = vreq.getParameter("subjectUri");
        if (session.getAttribute("requestedFromEntity") == null) {
            session.setAttribute("requestedFromEntity", (Object)subjectUri);
        }
    }

    private String processEditConfGeneratorName(VitroRequest vreq) {
        String editConfGeneratorName = null;
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        String domainUri = EditConfigurationUtils.getDomainUri(vreq);
        String rangeUri = EditConfigurationUtils.getRangeUri(vreq);
        String formParam = this.getFormParam(vreq);
        if (formParam != null && !formParam.isEmpty()) {
            editConfGeneratorName = formParam;
        } else {
            Property prop;
            if (this.isDeleteForm(vreq)) {
                return "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultDeleteGenerator";
            }
            editConfGeneratorName = predicateUri != null && !predicateUri.isEmpty() ? ((prop = this.getProperty(predicateUri, domainUri, rangeUri, vreq)) != null && rangeUri != null ? this.getCustomEntryForm(prop) : (prop != null && prop.getCustomEntryForm() != null ? prop.getCustomEntryForm() : (RDFS.label.getURI().equals(predicateUri) ? "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.RDFSLabelGenerator" : (this.isDataProperty(prop) ? "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultDataPropertyFormGenerator" : "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultObjectPropertyFormGenerator")))) : "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultObjectPropertyFormGenerator";
        }
        if (editConfGeneratorName == null) {
            log.error((Object)"problem: editConfGeneratorName is null but processEditConfGeneratorName() should never return null.");
        }
        log.debug((Object)("generator name is " + editConfGeneratorName));
        return editConfGeneratorName;
    }

    private String getCustomEntryForm(Property prop) {
        if (prop.getCustomEntryForm() == null) {
            return "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultObjectPropertyFormGenerator";
        }
        return prop.getCustomEntryForm();
    }

    private Property getProperty(String predicateUri, String domainUri, String rangeUri, VitroRequest vreq) {
        Property p = null;
        try {
            p = vreq.getWebappDaoFactory().getObjectPropertyDao().getObjectPropertyByURIs(predicateUri, domainUri, rangeUri);
            if (p == null) {
                p = vreq.getWebappDaoFactory().getDataPropertyDao().getDataPropertyByURI(predicateUri);
            }
        }
        catch (Throwable th) {
            log.debug((Object)"Not really a problem if we cannot get a property because we might be editing arbritrary RDF", th);
        }
        return p;
    }

    private boolean isVitroLabel(String predicateUri) {
        return predicateUri.equals("http://www.w3.org/2000/01/rdf-schema#label");
    }

    private boolean isDataProperty(Property prop) {
        return prop != null && prop instanceof DataProperty;
    }

    private boolean isSkipPredicate(VitroRequest vreq) {
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        String predicateUri = vreq.getParameter("predicateUri");
        boolean isEditOfExistingStmt = this.isEditOfExistingStmt(vreq);
        return isEditOfExistingStmt && wdf.getObjectPropertyDao().skipEditForm(predicateUri);
    }

    private ResponseValues processSkipEditForm(VitroRequest vreq) {
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap();
        params.put("uri", EditConfigurationUtils.getObjectUri(vreq));
        params.put("relatedSubjectUri", EditConfigurationUtils.getSubjectUri(vreq));
        params.put("relatingPredicateUri", EditConfigurationUtils.getPredicateUri(vreq));
        return new DirectRedirectResponseValues(UrlBuilder.getUrl(UrlBuilder.Route.INDIVIDUAL, params), 303);
    }

    private boolean isErrorCondition(VitroRequest vreq) {
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        String formParam = this.getFormParam(vreq);
        if ((formParam == null || "".equals(formParam)) && !this.isDeleteForm(vreq)) {
            if (predicateUri == null || predicateUri.trim().length() == 0) {
                return true;
            }
            if (subjectUri == null || subjectUri.trim().length() == 0) {
                return true;
            }
        }
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        return formParam == null && predicateUri != null && !EditConfigurationUtils.isObjectProperty(predicateUri, vreq) && !this.isVitroLabel(predicateUri) && !EditConfigurationUtils.isDataProperty(predicateUri, vreq);
    }

    private String getErrorMessage(VitroRequest vreq) {
        String errorMessage = null;
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        String formParam = this.getFormParam(vreq);
        if (formParam == null || "".equals(formParam)) {
            if (predicateUri == null || predicateUri.trim().length() == 0) {
                errorMessage = "No form was specified, both predicateUri and editform are empty. One of these is required by editRequestDispatch to choose a form.";
            }
            if (subjectUri == null || subjectUri.trim().length() == 0) {
                return "subjectUri was empty. If no editForm is specified, it is required by EditRequestDispatch.";
            }
        }
        return errorMessage;
    }

    private String getFormParam(VitroRequest vreq) {
        String formParam = vreq.getParameter("editForm");
        return formParam;
    }

    private boolean isEditOfExistingStmt(VitroRequest vreq) {
        String objectUri = vreq.getParameter("objectUri");
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        if (objectUri != null) {
            Individual object = wdf.getIndividualDao().getIndividualByURI(objectUri);
            return object != null;
        }
        return false;
    }

    private boolean isDeleteForm(VitroRequest vreq) {
        String command = vreq.getParameter("cmd");
        return "delete".equals(command);
    }

    private EditConfigurationVTwo makeEditConfigurationVTwo(String editConfGeneratorName, VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationGenerator EditConfigurationVTwoGenerator = null;
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(editConfGeneratorName);
            object = classDefinition.newInstance();
            EditConfigurationVTwoGenerator = object;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            System.out.println(e);
        }
        if (EditConfigurationVTwoGenerator == null) {
            throw new Error("Could not find EditConfigurationVTwoGenerator " + editConfGeneratorName);
        }
        log.debug((Object)("Created EditConfiguration using " + editConfGeneratorName));
        return EditConfigurationVTwoGenerator.getEditConfiguration(vreq, session);
    }

    private ResponseValues doHelp(VitroRequest vreq, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorMessage", "help is not yet implemented");
        return new TemplateResponseValues("error-message.ftl", map);
    }

    private String getSubmissionUrl(VitroRequest vreq) {
        return vreq.getContextPath() + "/edit/process";
    }
}

