/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterN3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Literal;

public abstract class ProcessDataGetterAbstract
implements ProcessDataGetterN3 {
    public static String classTypeVarBase = "classType";
    protected Map<String, List<Literal>> existingLiteralValues = new HashMap<String, List<Literal>>();
    protected Map<String, List<String>> existingUriValues = new HashMap<String, List<String>>();

    @Override
    public String getDataGetterVar(int counter) {
        return "?" + this.getDataGetterVarName(counter);
    }

    @Override
    public String getDataGetterVarName(int counter) {
        return "dataGetter" + counter;
    }

    public String getPrefixes() {
        return "@prefix display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> . \n@prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> . \n";
    }

    @Override
    public String getVarName(String base, int counter) {
        return base + counter;
    }

    public String getN3VarName(String base, int counter) {
        return "?" + this.getVarName(base, counter);
    }

    @Override
    public String replaceEncodedQuotesWithEscapedQuotes(String inputStr) {
        return inputStr.replaceAll("&#39;", "'").replaceAll("&quot;", "\"");
    }

    @Override
    public List<String> getNewResources(int counter) {
        ArrayList<String> newResources = new ArrayList<String>();
        newResources.add("dataGetter" + counter);
        return newResources;
    }

    protected String getSparqlPrefix() {
        return "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>";
    }

    @Override
    public Map<String, List<Literal>> retrieveExistingLiteralValues() {
        return this.existingLiteralValues;
    }

    @Override
    public Map<String, List<String>> retrieveExistingUriValues() {
        return this.existingUriValues;
    }

    public void populateExistingDataGetterURI(String dataGetterURI, int counter) {
        this.existingUriValues.put(this.getVarName("dataGetter", counter), new ArrayList<String>(Arrays.asList(dataGetterURI)));
    }

    public void populateExistingClassType(String classType, int counter) {
        this.existingUriValues.put(this.getVarName(classTypeVarBase, counter), new ArrayList<String>(Arrays.asList(classType)));
    }
}

