/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterAbstract;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class ProcessClassGroupDataGetterN3
extends ProcessDataGetterAbstract {
    private static String classType = "java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.ClassGroupPageData";
    public static String classGroupVarBase = "classGroup";
    private Log log = LogFactory.getLog(ProcessClassGroupDataGetterN3.class);

    @Override
    public List<String> retrieveN3Required(int counter) {
        return this.retrieveN3ForTypeAndClassGroup(counter);
    }

    @Override
    public List<String> retrieveN3Optional(int counter) {
        return null;
    }

    public List<String> retrieveN3ForTypeAndClassGroup(int counter) {
        String n3ForType = this.getN3ForTypePartial(counter);
        String n3 = n3ForType + "; \n<" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup" + "> " + this.getN3VarName(classGroupVarBase, counter) + " .";
        ArrayList<String> n3List = new ArrayList<String>();
        n3List.add(this.getPrefixes() + n3);
        return n3List;
    }

    public String getN3ForTypePartial(int counter) {
        String dataGetterVar = this.getDataGetterVar(counter);
        String classTypeVar = this.getN3VarName(classTypeVarBase, counter);
        String n3 = dataGetterVar + " a " + classTypeVar;
        return n3;
    }

    @Override
    public List<String> retrieveLiteralsOnForm(int counter) {
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        return literalsOnForm;
    }

    @Override
    public List<String> retrieveUrisOnForm(int counter) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        urisOnForm.add(this.getVarName("classGroup", counter));
        urisOnForm.add(this.getVarName(classTypeVarBase, counter));
        return urisOnForm;
    }

    @Override
    public List<FieldVTwo> retrieveFields(int counter) {
        ArrayList<FieldVTwo> fields = new ArrayList<FieldVTwo>();
        fields.add(new FieldVTwo().setName(this.getVarName("classGroup", counter)));
        fields.add(new FieldVTwo().setName(this.getVarName(classTypeVarBase, counter)));
        return fields;
    }

    @Override
    public List<String> getLiteralVarNamesBase() {
        return Arrays.asList(new String[0]);
    }

    @Override
    public List<String> getUriVarNamesBase() {
        return Arrays.asList("classGroup", classTypeVarBase);
    }

    @Override
    public String getClassType() {
        return classType;
    }

    @Override
    public void populateExistingValues(String dataGetterURI, int counter, OntModel queryModel) {
        this.populateExistingDataGetterURI(dataGetterURI, counter);
        this.populateExistingClassType(this.getClassType(), counter);
        String querystr = this.getExistingValuesClassGroup(dataGetterURI);
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Resource classGroupResource = qs.getResource("classGroup");
                this.existingUriValues.put(this.getVarName(classGroupVarBase, counter), new ArrayList<String>(Arrays.asList(classGroupResource.getURI())));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
    }

    protected String getExistingValuesClassGroup(String dataGetterURI) {
        String query = this.getSparqlPrefix() + " SELECT ?classGroup  WHERE {<" + dataGetterURI + "> <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup" + "> ?classGroup  . \n}";
        return query;
    }

    @Override
    public ObjectNode getExistingValuesJSON(String dataGetterURI, OntModel queryModel, ServletContext context) {
        ObjectNode jObject = new ObjectMapper().createObjectNode();
        jObject.put("dataGetterClass", classType);
        jObject.put(classTypeVarBase, classType);
        this.getExistingClassGroup(dataGetterURI, jObject, queryModel);
        this.getExistingClassesInClassGroup(context, dataGetterURI, jObject);
        return jObject;
    }

    private void getExistingClassGroup(String dataGetterURI, ObjectNode jObject, OntModel queryModel) {
        String querystr = this.getExistingValuesClassGroup(dataGetterURI);
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Resource classGroupResource = qs.getResource("classGroup");
                jObject.put(classGroupVarBase, classGroupResource.getURI());
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
    }

    protected void getExistingClassesInClassGroup(ServletContext context, String dataGetterURI, ObjectNode jObject) {
        if (jObject.has(classGroupVarBase)) {
            String classGroupURI = jObject.get(classGroupVarBase).asText();
            VClassGroupCache vcgc = VClassGroupCache.getVClassGroupCache(context);
            VClassGroup group = vcgc.getGroup(classGroupURI);
            this.populateClassesInClassGroupJSON(jObject, group);
        } else {
            this.log.error((Object)"JSONObject does not have class group URI included. ");
        }
    }

    protected void populateClassesInClassGroupJSON(ObjectNode jObject, VClassGroup group) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode classes = mapper.createArrayNode();
        for (VClass vc : group) {
            ObjectNode vcObj = mapper.createObjectNode();
            vcObj.put("name", vc.getName());
            vcObj.put("URI", vc.getURI());
            classes.add((JsonNode)vcObj);
        }
        ObjectNode results = mapper.createObjectNode();
        results.set("classes", (JsonNode)classes);
        results.put("classGroupName", group.getPublicName());
        results.put("classGroupUri", group.getURI());
        jObject.set("results", (JsonNode)results);
    }
}

