/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.EditLiteral;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.RdfLiteralHash;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.DefaultDataPropEmptyField;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.DefaultDataPropertyFormValidator;
import java.util.Arrays;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;

public class DefaultDataPropertyFormGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    private static Log log = LogFactory.getLog(DefaultDataPropertyFormGenerator.class);
    static final String literalVar = "literal";
    static final String literalPlaceholder = "?literal";
    static final String dataPropN3 = "?subject ?predicate ?literal . ";

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        Integer dataHash;
        String subjectUri = vreq.getParameter("subjectUri");
        Individual subject = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(subjectUri);
        if (subject == null) {
            throw new Error("In DefaultDataPropertyFormGenerator, could not find individual for URI " + subjectUri);
        }
        String predicateUri = vreq.getParameter("predicateUri");
        WebappDaoFactory unfilteredWdf = vreq.getUnfilteredWebappDaoFactory();
        DataProperty dataproperty = unfilteredWdf.getDataPropertyDao().getDataPropertyByURI(predicateUri);
        dataproperty = vreq.getWebappDaoFactory().getDataPropertyDao().getDataPropertyByURI(predicateUri);
        if (dataproperty == null && !predicateUri.equals("http://www.w3.org/2000/01/rdf-schema#label")) {
            log.error((Object)("Could not find data property '" + predicateUri + "' in model"));
            throw new Error("Could not find DataProperty in model: " + predicateUri);
        }
        String rangeDatatypeUri = dataproperty.getRangeDatatypeURI();
        if (rangeDatatypeUri == null || rangeDatatypeUri.trim().isEmpty()) {
            rangeDatatypeUri = vreq.getWebappDaoFactory().getDataPropertyDao().getRequiredDatatypeURI(subject, dataproperty);
        }
        boolean update = (dataHash = EditConfigurationUtils.getDataHash(vreq)) != null;
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initBasics(editConfiguration, vreq);
        this.initPropertyParameters(vreq, session, editConfiguration);
        editConfiguration.setTemplate("defaultDataPropertyForm.ftl");
        editConfiguration.setDatapropKey(dataHash);
        editConfiguration.setVarNameForSubject("subject");
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setVarNameForObject(literalVar);
        editConfiguration.setLiteralsOnForm(Arrays.asList(literalVar));
        FieldVTwo literalField = new FieldVTwo().setName(literalVar).setRangeDatatypeUri(rangeDatatypeUri);
        editConfiguration.addField(literalField);
        editConfiguration.addValidator(new AntiXssValidation());
        if (update) {
            editConfiguration.addModelChangePreprocessor(new DefaultDataPropEmptyField());
            editConfiguration.setN3Optional(Arrays.asList(dataPropN3));
        } else {
            literalField.setValidators(DefaultDataPropertyFormGenerator.list("nonempty"));
            editConfiguration.setN3Required(Arrays.asList(dataPropN3));
        }
        if (rangeDatatypeUri != null) {
            editConfiguration.addValidator(new DefaultDataPropertyFormValidator(rangeDatatypeUri, vreq));
        }
        this.prepare(vreq, editConfiguration);
        return editConfiguration;
    }

    public static void prepareForDataPropUpdate(Model model, EditConfigurationVTwo editConfiguration, DataPropertyDao dataPropertyDao) {
        String subjectUri = editConfiguration.getSubjectUri();
        String predicateUri = editConfiguration.getPredicateUri();
        Integer dataHash = editConfiguration.getDatapropKey();
        if (predicateUri == null) {
            throw new Error("predicateUri was null");
        }
        DataProperty dataproperty = dataPropertyDao.getDataPropertyByURI(predicateUri);
        if (dataproperty == null && !"http://www.w3.org/2000/01/rdf-schema#label".equals(predicateUri)) {
            throw new Error("could not get data property for " + predicateUri);
        }
        DataPropertyStatement dps = null;
        if (dataHash == null) {
            throw new Error("prepareForDataPropUpdate() should not be called if the EditConfiguration is not a data property statement update ");
        }
        dps = RdfLiteralHash.getPropertyStmtByHash(subjectUri, predicateUri, dataHash, model);
        if (dps == null) {
            throw new Error("No match to existing data property \"" + predicateUri + "\" statement for subject \"" + subjectUri + "\" via key " + dataHash);
        }
        editConfiguration.addLiteralInScope(editConfiguration.getVarNameForObject(), new EditLiteral(dps.getData(), dps.getDatatypeURI(), dps.getLanguage()));
        DefaultDataPropertyFormGenerator.dataTypeDebug(dps, dataproperty);
    }

    private static void dataTypeDebug(DataPropertyStatement dps, DataProperty dataproperty) {
        if (dps == null) {
            return;
        }
        String statementDataType = null;
        String statementLang = null;
        statementLang = dps.getLanguage();
        if (statementLang == null) {
            log.debug((Object)"no language attribute on data property statement in DefaultDataPropertyFormGenerator");
        } else {
            log.debug((Object)("language attribute of [" + statementLang + "] on data property statement in DefaultDataPropertyFormGenerator"));
        }
        if (dataproperty == null) {
            return;
        }
        statementDataType = dps.getDatatypeURI();
        if (statementDataType == null) {
            log.debug((Object)("no range datatype uri set on data property statement when property's range datatype is " + dataproperty.getRangeDatatypeURI() + " in DefaultDataPropertyFormGenerator"));
        } else {
            log.debug((Object)("range datatype uri of [" + statementDataType + "] on data property statement in DefaultDataPropertyFormGenerator"));
        }
    }
}

