/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.vclassgroup;

import edu.cornell.mannlib.vitro.webapp.dao.DisplayVocabulary;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.listeners.StatementListener;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;

public class ProhibitedFromSearch {
    List<String> prohibitedClasses;
    String ProhibitedFromSearchURI;
    private static final String queryForProhibitedClasses = "SELECT ?prohibited WHERE{?searchConfig <" + DisplayVocabulary.EXCLUDE_CLASS + "> ?prohibited . }";
    protected static final Log log = LogFactory.getLog((String)ProhibitedFromSearch.class.getName());

    public ProhibitedFromSearch(String URI2, OntModel model) {
        this.ProhibitedFromSearchURI = URI2;
        this.prohibitedClasses = new ArrayList<String>();
        this.addAllProhibitedClasses(this.buildProhibitedClassesList(URI2, model));
        model.register((ModelChangedListener)new ProhibitedFromSearchChangeListener(this));
    }

    public synchronized boolean isClassProhibitedFromSearch(String classURI) {
        if (classURI != null) {
            boolean p = this.prohibitedClasses.contains(classURI);
            if (p) {
                log.debug((Object)(classURI + " is prohibited from search"));
            }
            return p;
        }
        return false;
    }

    private synchronized void removeProhibitedClass(String classURI) {
        this.prohibitedClasses.remove(classURI);
    }

    private synchronized void addProhibitedClass(String classURI) {
        this.prohibitedClasses.add(classURI);
    }

    private synchronized void addAllProhibitedClasses(List<String> classURIs) {
        this.prohibitedClasses.addAll(classURIs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> buildProhibitedClassesList(String URI2, OntModel model) {
        ArrayList<String> newProhibitedClasses;
        block10: {
            newProhibitedClasses = new ArrayList<String>();
            QuerySolutionMap initialBinding = new QuerySolutionMap();
            Resource searchConfig = ResourceFactory.createResource((String)URI2);
            initialBinding.add("searchConfig", (RDFNode)searchConfig);
            Query query = QueryFactory.create((String)queryForProhibitedClasses);
            model.enterCriticalSection(true);
            try {
                QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
                try {
                    ResultSet results = qExec.execSelect();
                    while (results.hasNext()) {
                        QuerySolution soln = results.nextSolution();
                        RDFNode n = soln.get("prohibited");
                        if (n.isResource() && !n.isAnon()) {
                            newProhibitedClasses.add(((Resource)n).getURI());
                            continue;
                        }
                        log.warn((Object)("unexpected node in object position for prohibited classes: " + n.toString()));
                    }
                }
                catch (Throwable t) {
                    try {
                        log.error((Object)t, t);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        qExec.close();
                    }
                }
                qExec.close();
            }
            finally {
                model.leaveCriticalSection();
            }
        }
        return newProhibitedClasses;
    }

    class ProhibitedFromSearchChangeListener
    extends StatementListener {
        ProhibitedFromSearch pfs;

        ProhibitedFromSearchChangeListener(ProhibitedFromSearch pfs) {
            this.pfs = pfs;
        }

        public void addedStatement(Statement s) {
            this.processChange(s, ChangeType.ADD);
        }

        public void removedStatement(Statement s) {
            this.processChange(s, ChangeType.REMOVE);
        }

        private void processChange(Statement s, ChangeType add) {
            String subURI;
            if (s != null && s.getPredicate() != null && s.getPredicate().getURI() != null && s.getPredicate().getURI().equals(DisplayVocabulary.EXCLUDE_CLASS.getURI()) && s.getSubject() != null && (subURI = s.getSubject().getURI()) != null && subURI.equals(ProhibitedFromSearch.this.ProhibitedFromSearchURI) && s.getObject() != null && s.getObject().canAs(Resource.class)) {
                String classURI = ((Resource)s.getObject().as(Resource.class)).getURI();
                if (add == ChangeType.ADD) {
                    this.pfs.addProhibitedClass(classURI);
                } else {
                    this.pfs.removeProhibitedClass(classURI);
                }
            }
        }
    }

    private static enum ChangeType {
        ADD,
        REMOVE;

    }
}

