/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.Classes2Classes;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.AnnotationProperty;
import org.apache.jena.ontology.ComplementClass;
import org.apache.jena.ontology.HasValueRestriction;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.IntersectionClass;
import org.apache.jena.ontology.MinCardinalityRestriction;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.ProfileException;
import org.apache.jena.ontology.Restriction;
import org.apache.jena.ontology.SomeValuesFromRestriction;
import org.apache.jena.ontology.UnionClass;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class VClassDaoJena
extends JenaBaseDao
implements VClassDao {
    protected static final Log log = LogFactory.getLog(VClassDaoJena.class);
    private final I18nBundle i18n;
    private boolean isUnderlyingStoreReasoned = false;

    public VClassDaoJena(WebappDaoFactoryJena wadf, boolean isUnderlyingStoreReasoned) {
        super(wadf);
        this.i18n = wadf.getI18nBundle();
        this.isUnderlyingStoreReasoned = isUnderlyingStoreReasoned;
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getTBoxModel();
    }

    protected boolean isUnderlyingStoreReasoned() {
        return this.isUnderlyingStoreReasoned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabelForClass(OntClass cls, boolean withPrefix, boolean forPickList) {
        cls.getModel().enterCriticalSection(true);
        try {
            if (cls.isAnon()) {
                if (cls.isRestriction()) {
                    Object cRest;
                    StringBuilder labelStr;
                    block42: {
                        MinCardinalityRestriction mcRest;
                        Restriction rest = cls.asRestriction();
                        OntProperty onProperty = rest.getOnProperty();
                        labelStr = new StringBuilder();
                        labelStr.append(String.format("%s ", this.i18n.text("restriction_on", new Object[0]))).append(this.getLabelOrId((OntResource)onProperty)).append(": ");
                        if (rest.isAllValuesFromRestriction() || rest.isSomeValuesFromRestriction()) {
                            Resource fillerRes = null;
                            if (rest.isAllValuesFromRestriction()) {
                                AllValuesFromRestriction avfRest = rest.asAllValuesFromRestriction();
                                fillerRes = avfRest.getAllValuesFrom();
                                labelStr.append(String.format("%s ", this.i18n.text("all_values_from", new Object[0])));
                            } else {
                                SomeValuesFromRestriction svfRest = rest.asSomeValuesFromRestriction();
                                fillerRes = svfRest.getSomeValuesFrom();
                                labelStr.append(String.format("%s ", this.i18n.text("some_values_from", new Object[0])));
                            }
                            if (fillerRes.canAs(OntClass.class)) {
                                OntClass avf = (OntClass)fillerRes.as(OntClass.class);
                                labelStr.append(this.getLabelForClass(avf, withPrefix, forPickList));
                            } else {
                                try {
                                    labelStr.append(this.getLabelOrId((OntResource)fillerRes.as(OntResource.class)));
                                }
                                catch (Exception e) {
                                    labelStr.append("???");
                                }
                            }
                        } else if (rest.isHasValueRestriction()) {
                            HasValueRestriction hvRest = rest.asHasValueRestriction();
                            labelStr.append(String.format("%s ", this.i18n.text("has_value", new Object[0])));
                            RDFNode fillerNode = hvRest.getHasValue();
                            try {
                                if (fillerNode.isResource()) {
                                    labelStr.append(this.getLabelOrId((OntResource)fillerNode.as(OntResource.class)));
                                    break block42;
                                }
                                labelStr.append(((Literal)fillerNode.as(Literal.class)).getLexicalForm());
                            }
                            catch (Exception e) {
                                labelStr.append("???");
                            }
                        } else if (rest.isMinCardinalityRestriction()) {
                            mcRest = rest.asMinCardinalityRestriction();
                            labelStr.append(String.format("%s ", this.i18n.text("minimum_cardinality", new Object[0])));
                            labelStr.append(mcRest.getMinCardinality());
                        } else if (rest.isMaxCardinalityRestriction()) {
                            mcRest = rest.asMaxCardinalityRestriction();
                            labelStr.append(String.format("%s ", this.i18n.text("maximum_cardinality", new Object[0])));
                            labelStr.append(mcRest.getMaxCardinality());
                        } else if (rest.isCardinalityRestriction()) {
                            cRest = rest.asCardinalityRestriction();
                            labelStr.append(String.format("%s ", this.i18n.text("cardinality", new Object[0])));
                            labelStr.append(cRest.getCardinality());
                        }
                    }
                    cRest = labelStr.toString();
                    return cRest;
                }
                if (this.isBooleanClassExpression(cls)) {
                    Object icls;
                    StringBuilder labelStr = new StringBuilder("(");
                    if (cls.isComplementClass()) {
                        labelStr.append(String.format("%s ", this.i18n.text("not", new Object[0])));
                        ComplementClass ccls = (ComplementClass)cls.as(ComplementClass.class);
                        labelStr.append(this.getLabelForClass(ccls.getOperand(), withPrefix, forPickList));
                    } else if (cls.isIntersectionClass()) {
                        icls = (IntersectionClass)cls.as(IntersectionClass.class);
                        ExtendedIterator operandIt = icls.listOperands();
                        while (operandIt.hasNext()) {
                            OntClass operand = (OntClass)operandIt.next();
                            labelStr.append(this.getLabelForClass(operand, withPrefix, forPickList));
                            if (!operandIt.hasNext()) continue;
                            labelStr.append(String.format(" %s ", this.i18n.text("and", new Object[0])));
                        }
                    } else if (cls.isUnionClass()) {
                        icls = (UnionClass)cls.as(UnionClass.class);
                        ExtendedIterator operandIt = icls.listOperands();
                        while (operandIt.hasNext()) {
                            OntClass operand = (OntClass)operandIt.next();
                            labelStr.append(this.getLabelForClass(operand, withPrefix, forPickList));
                            if (!operandIt.hasNext()) continue;
                            labelStr.append(String.format(" %s ", this.i18n.text("or", new Object[0])));
                        }
                    }
                    icls = labelStr.append(")").toString();
                    return icls;
                }
                String labelStr = "<a href=\"vclassEdit?uri=" + URLEncoder.encode(this.getClassURIStr((Resource)cls)) + "\">[anonymous class]</a>";
                return labelStr;
            }
            if (withPrefix || forPickList) {
                OntologyDao oDao = this.getWebappDaoFactory().getOntologyDao();
                Ontology o = oDao.getOntologyByURI(cls.getNameSpace());
                if (o != null) {
                    if (withPrefix) {
                        String string = o.getPrefix() == null ? (o.getName() == null ? "unspec:" + this.getLabelOrId((OntResource)cls) : o.getName() + ":" + this.getLabelOrId((OntResource)cls)) : o.getPrefix() + ":" + this.getLabelOrId((OntResource)cls);
                        return string;
                    }
                    String string = this.getLabelOrId((OntResource)cls) + (o.getPrefix() == null ? (o.getName() == null ? " (unspec)" : " (" + o.getName() + ")") : " (" + o.getPrefix() + ")");
                    return string;
                }
                String string = this.getLabelOrId((OntResource)cls);
                return string;
            }
            String oDao = this.getLabelOrId((OntResource)cls);
            return oDao;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            String string = "???";
            return string;
        }
        finally {
            cls.getModel().leaveCriticalSection();
        }
    }

    @Override
    public void deleteVClass(VClass cls) {
        this.deleteVClass(cls, this.getOntModel());
    }

    @Override
    public void deleteVClass(String URI2) {
        this.deleteVClass(URI2, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVClass(String URI2, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            OntClass cls = this.getOntClass(ontModel, URI2);
            if (cls != null) {
                OntResource restOntRes;
                Resource restRes;
                ResIterator restIt = ontModel.listSubjectsWithProperty(OWL.allValuesFrom, (RDFNode)cls);
                while (restIt.hasNext()) {
                    restRes = (Resource)restIt.next();
                    if (!restRes.canAs(OntResource.class)) continue;
                    restOntRes = (OntResource)restRes.as(OntResource.class);
                    this.smartRemove(restOntRes, ontModel);
                }
                restIt = ontModel.listSubjectsWithProperty(OWL.someValuesFrom, (RDFNode)cls);
                while (restIt.hasNext()) {
                    restRes = (Resource)restIt.next();
                    if (!restRes.canAs(OntResource.class)) continue;
                    restOntRes = (OntResource)restRes.as(OntResource.class);
                    this.smartRemove(restOntRes, ontModel);
                }
                this.removeRulesMentioningResource((Resource)cls, ontModel);
                this.smartRemove((OntResource)cls, ontModel);
            }
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
    }

    public void deleteVClass(VClass cls, OntModel ontModel) {
        this.deleteVClass(cls.getURI(), ontModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDisjointWithClassURIs(String classURI) {
        OntClass ontClass = this.getOntClass(this.getOntModel(), classURI);
        ArrayList<String> uriList = new ArrayList<String>();
        this.getOntModel().enterCriticalSection(true);
        try {
            ExtendedIterator i = ontClass.listDisjointWith();
            while (i.hasNext()) {
                OntClass disjointClass = (OntClass)i.next();
                uriList.add(this.getClassURIStr((Resource)disjointClass));
            }
        }
        catch (ProfileException pe) {
            log.error((Object)pe, (Throwable)pe);
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return uriList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDisjointWithClass(String classURI, String disjointClassURI) {
        this.getOntModel().enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            OntClass ontClass = this.getOntClass(this.getOntModel(), classURI);
            OntClass disjointClass = this.getOntClass(this.getOntModel(), disjointClassURI);
            ontClass.addDisjointWith((Resource)disjointClass);
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDisjointWithClass(String classURI, String disjointClassURI) {
        this.getOntModel().enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            OntClass ontClass = this.getOntClass(this.getOntModel(), classURI);
            OntClass disjointClass = this.getOntClass(this.getOntModel(), disjointClassURI);
            ontClass.removeDisjointWith((Resource)disjointClass);
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getEquivalentClassURIs(String classURI) {
        ArrayList<String> equivalentClassURIs = new ArrayList<String>();
        this.getOntModel().enterCriticalSection(true);
        try {
            OntClass ontClass = this.getOntClass(this.getOntModel(), classURI);
            try (ExtendedIterator equivalentOntClassIt = ontClass.listEquivalentClasses();){
                ExtendedIterator eqOntClassIt = equivalentOntClassIt;
                while (eqOntClassIt.hasNext()) {
                    OntClass eqClass = (OntClass)eqOntClassIt.next();
                    equivalentClassURIs.add(this.getClassURIStr((Resource)eqClass));
                }
            }
        }
        catch (ProfileException ontClass) {
        }
        catch (Exception e) {
            List<Resource> supList = this.listDirectObjectPropertyValues(this.getOntModel().getResource(classURI), OWL.equivalentClass);
            for (Resource res : supList) {
                equivalentClassURIs.add(this.getClassURIStr(res));
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return equivalentClassURIs;
    }

    @Override
    public void addSuperclass(VClass vclass, VClass superclass) {
        this.addSuperclass(vclass.getURI(), superclass.getURI());
    }

    @Override
    public void addSuperclass(String vclassURI, String superclassURI) {
        Classes2Classes c2c = new Classes2Classes();
        c2c.setSubclassURI(vclassURI);
        c2c.setSuperclassURI(superclassURI);
        this.insertNewClasses2Classes(c2c);
    }

    @Override
    public void removeSuperclass(VClass vclass, VClass superclass) {
        this.removeSuperclass(vclass.getURI(), superclass.getURI());
    }

    @Override
    public void removeSuperclass(String vclassURI, String superclassURI) {
        Classes2Classes c2c = new Classes2Classes();
        c2c.setSubclassURI(vclassURI);
        c2c.setSuperclassURI(superclassURI);
        this.deleteClasses2Classes(c2c);
    }

    @Override
    public void addSubclass(VClass vclass, VClass subclass) {
        this.addSubclass(vclass.getURI(), subclass.getURI());
    }

    @Override
    public void addSubclass(String vclassURI, String subclassURI) {
        Classes2Classes c2c = new Classes2Classes();
        c2c.setSubclassURI(subclassURI);
        c2c.setSuperclassURI(vclassURI);
        this.insertNewClasses2Classes(c2c);
    }

    @Override
    public void removeSubclass(VClass vclass, VClass subclass) {
        this.removeSubclass(vclass.getURI(), subclass.getURI());
    }

    @Override
    public void removeSubclass(String vclassURI, String subclassURI) {
        Classes2Classes c2c = new Classes2Classes();
        c2c.setSubclassURI(subclassURI);
        c2c.setSuperclassURI(vclassURI);
        this.deleteClasses2Classes(c2c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEquivalentClass(String classURI, String equivalentClassURI) {
        this.getOntModel().enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            OntClass ontClass = this.getOntClass(this.getOntModel(), classURI);
            OntClass eqClass = this.getOntClass(this.getOntModel(), equivalentClassURI);
            ontClass.addEquivalentClass((Resource)eqClass);
            eqClass.addEquivalentClass((Resource)ontClass);
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEquivalentClass(String classURI, String equivalentClassURI) {
        this.getOntModel().enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            OntClass ontClass = this.getOntClass(this.getOntModel(), classURI);
            OntClass eqClass = this.getOntClass(this.getOntModel(), equivalentClassURI);
            ontClass.removeEquivalentClass((Resource)eqClass);
            eqClass.removeEquivalentClass((Resource)ontClass);
            if (ontClass.isAnon()) {
                this.smartRemove((OntResource)ontClass, this.getOntModel());
            }
            if (eqClass.isAnon()) {
                this.smartRemove((OntResource)eqClass, this.getOntModel());
            }
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            this.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public List<String> getAllSubClassURIs(String classURI) {
        HashSet<String> nodeSet = new HashSet<String>();
        nodeSet.add(classURI);
        this.getAllSubClassURIs(classURI, nodeSet);
        nodeSet.remove(classURI);
        ArrayList<String> outputList = new ArrayList<String>();
        outputList.addAll(nodeSet);
        return outputList;
    }

    public void getAllSubClassURIs(String classURI, HashSet<String> subtree) {
        List<String> directSubclasses = this.getSubClassURIs(classURI);
        for (String uri : directSubclasses) {
            if (subtree.contains(uri)) continue;
            subtree.add(uri);
            this.getAllSubClassURIs(uri, subtree);
        }
    }

    @Override
    public List<String> getAllSuperClassURIs(String classURI) {
        ArrayList<String> superclassURIs = null;
        if (this.isUnderlyingStoreReasoned()) {
            superclassURIs = new ArrayList<String>();
            Resource cls = ResourceFactory.createResource((String)classURI);
            StmtIterator superClassIt = this.getOntModel().listStatements(cls, RDFS.subClassOf, (RDFNode)null);
            while (superClassIt.hasNext()) {
                Statement stmt = superClassIt.nextStatement();
                if (!stmt.getObject().canAs(OntResource.class)) continue;
                OntResource superRes = (OntResource)stmt.getObject().as(OntResource.class);
                String test = this.getClassURIStr((Resource)superRes);
                superclassURIs.add(test);
            }
            return superclassURIs;
        }
        HashSet<String> nodeSet = new HashSet<String>();
        nodeSet.add(classURI);
        this.getAllSuperClassURIs(classURI, nodeSet);
        return new ArrayList<String>(nodeSet);
    }

    public void getAllSuperClassURIs(String classURI, HashSet<String> subtree) {
        List<String> directSuperclasses = this.getSuperClassURIs(classURI, true);
        for (String uri : directSuperclasses) {
            if (subtree.contains(uri)) continue;
            subtree.add(uri);
            this.getAllSuperClassURIs(uri, subtree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<VClass> getAllVclasses() {
        ArrayList<VClass> classes = new ArrayList<VClass>();
        this.getOntModel().enterCriticalSection(true);
        try (ExtendedIterator classIt = this.getOntModel().listIndividuals(OWL.Class);){
            while (classIt.hasNext()) {
                try {
                    OntClass cls;
                    Individual classInd = (Individual)classIt.next();
                    if (!classInd.canAs(OntClass.class) || (cls = (OntClass)classInd.as(OntClass.class)).isAnon() || this.NONUSER_NAMESPACES.contains(cls.getNameSpace())) continue;
                    classes.add(new VClassJena(cls, this.getWebappDaoFactory()));
                }
                catch (ClassCastException cce) {
                    log.error((Object)cce, (Throwable)cce);
                }
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        Collections.sort(classes);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<OntClass> smarterListHierarchyRootClasses(OntModel ontModel, String ontologyURI) {
        ArrayList<OntClass> rootClassList = new ArrayList<OntClass>();
        try (ResIterator ci = ontModel.listResourcesWithProperty(RDF.type, (RDFNode)OWL.Class);){
            ResIterator i = ci;
            while (i.hasNext()) {
                try {
                    Resource ontClass = i.nextResource();
                    boolean isRoot = true;
                    StmtIterator j = ontClass.listProperties(RDFS.subClassOf);
                    while (j.hasNext()) {
                        Resource superClass;
                        Statement stmt = j.nextStatement();
                        if (!stmt.getObject().isResource() || (superClass = (Resource)stmt.getObject()).isAnon() || ontologyURI != null && !ontologyURI.equals(superClass.getNameSpace()) || OWL.Thing.equals((Object)superClass) || superClass.equals((Object)ontClass) || ontModel.contains(ontClass, OWL.equivalentClass, (RDFNode)superClass) || ontModel.contains(superClass, OWL.equivalentClass, (RDFNode)ontClass) || superClass.getNameSpace() == null || this.NONUSER_NAMESPACES.contains(superClass.getNameSpace())) continue;
                        isRoot = false;
                        break;
                    }
                    if (!isRoot || !ontClass.canAs(OntClass.class)) continue;
                    rootClassList.add((OntClass)ontClass.as(OntClass.class));
                }
                catch (ClassCastException cce) {
                    log.error((Object)cce, (Throwable)cce);
                }
            }
        }
        return rootClassList.iterator();
    }

    @Override
    public List<VClass> getRootClasses() {
        return this.getRootClasses(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VClass> getRootClasses(String ontologyURI) {
        ArrayList<VClass> rootClasses = new ArrayList<VClass>();
        this.getOntModel().enterCriticalSection(true);
        try {
            Iterator<OntClass> rootIt = this.smarterListHierarchyRootClasses(this.getOntModel(), ontologyURI);
            while (rootIt.hasNext()) {
                OntClass cls = rootIt.next();
                if (cls.isAnon() || cls.getNameSpace() == null || this.NONUSER_NAMESPACES.contains(cls.getNameSpace())) continue;
                rootClasses.add(new VClassJena(cls, this.getWebappDaoFactory()));
            }
            Collections.sort(rootClasses);
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return rootClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VClass> getOntologyRootClasses(String ontologyURI) {
        if (ontologyURI == null) {
            throw new RuntimeException("can't find root classes for null ontology URI");
        }
        ArrayList<VClass> ontologyRootClasses = new ArrayList<VClass>();
        OntModel ontModel = this.getOntModel();
        ontModel.enterCriticalSection(true);
        try {
            ResIterator ontClassIt = ontModel.listResourcesWithProperty(RDF.type, (RDFNode)OWL.Class);
            while (ontClassIt.hasNext()) {
                Resource ontClass = (Resource)ontClassIt.next();
                if (!ontologyURI.equals(ontClass.getNameSpace())) continue;
                boolean root = true;
                try (StmtIterator superStmtIt = ontModel.listStatements(ontClass, RDFS.subClassOf, (RDFNode)null);){
                    while (superStmtIt.hasNext()) {
                        Statement superStmt = superStmtIt.nextStatement();
                        if (!superStmt.getObject().isResource() || !ontologyURI.equals(((Resource)superStmt.getObject()).getNameSpace())) continue;
                        root = false;
                        break;
                    }
                }
                if (!root || !ontClass.canAs(OntClass.class)) continue;
                ontologyRootClasses.add(new VClassJena((OntClass)ontClass.as(OntClass.class), this.getWebappDaoFactory()));
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return ontologyRootClasses;
    }

    @Override
    public List<String> getSubClassURIs(String classURI) {
        ArrayList<String> subURIs = new ArrayList<String>();
        OntClass superClass = this.getOntClass(this.getOntModel(), classURI);
        try {
            ExtendedIterator subIt = superClass.listSubClasses(true);
            while (subIt.hasNext()) {
                OntClass cls = (OntClass)subIt.next();
                subURIs.add(this.getClassURIStr((Resource)cls));
            }
        }
        catch (Exception e) {
            List<Resource> supList = this.listDirectObjectPropertySubjects(this.getOntModel().getResource(classURI), RDFS.subClassOf);
            for (Resource res : supList) {
                subURIs.add(res.getURI());
            }
        }
        return subURIs;
    }

    @Override
    public List<String> getSuperClassURIs(String classURI, boolean direct) {
        ArrayList<String> supURIs = new ArrayList<String>();
        OntClass subClass = this.getOntClass(this.getOntModel(), classURI);
        try {
            ExtendedIterator supIt = subClass.listSuperClasses(direct);
            while (supIt.hasNext()) {
                OntClass cls = (OntClass)supIt.next();
                supURIs.add(this.getClassURIStr((Resource)cls));
            }
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
            supURIs.clear();
            List<Resource> supList = direct ? this.listDirectObjectPropertyValues((Resource)subClass, RDFS.subClassOf) : this.listObjectPropertyValues((Resource)subClass, RDFS.subClassOf);
            for (Resource res : supList) {
                supURIs.add(this.getClassURIStr(res));
            }
        }
        return supURIs;
    }

    private List<Resource> listObjectPropertyValues(Resource res, Property prop) {
        ArrayList<Resource> values = new ArrayList<Resource>();
        StmtIterator stmtIt = res.listProperties(prop);
        while (stmtIt.hasNext()) {
            Statement s = stmtIt.nextStatement();
            if (!s.getObject().isResource()) continue;
            values.add(s.getObject().asResource());
        }
        return values;
    }

    @Override
    public VClass getTopConcept() {
        VClass top = new VClass();
        if (this.getOntModel().getProfile().NAMESPACE().equals(RDFS.getURI())) {
            top.setURI(RDF.getURI() + "Resource");
        } else {
            top.setURI(this.getOntModel().getProfile().THING().getURI());
        }
        if (top.getURI() != null) {
            top.setName(top.getLocalName());
            return top;
        }
        return null;
    }

    @Override
    public VClass getBottomConcept() {
        VClass bottom = new VClass();
        if (this.getOntModel().getProfile().NAMESPACE().equals(RDFS.getURI())) {
            return null;
        }
        bottom.setURI(this.getOntModel().getProfile().NOTHING().getURI());
        if (bottom.getURI() != null) {
            bottom.setName(bottom.getLocalName());
            return bottom;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VClass getVClassByURI(String URIStr) {
        this.getOntModel().enterCriticalSection(true);
        try {
            OntClass cls = this.getOntClass(this.getOntModel(), URIStr);
            if (cls != null) {
                VClassJena vClassJena = new VClassJena(cls, this.getWebappDaoFactory());
                return vClassJena;
            }
            VClass vClass = null;
            return vClass;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public void insertNewVClass(VClass cls) throws InsertException {
        this.insertNewVClass(cls, this.getOntModelSelector().getTBoxModel());
    }

    @Override
    public List<VClass> getVClassesForProperty(String propertyURI, boolean domainSide) {
        return this.getVClassesForProperty(null, propertyURI, domainSide);
    }

    @Override
    public List<VClass> getVClassesForProperty(String vclassURI, String propertyURI) {
        return this.getVClassesForProperty(vclassURI, propertyURI, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VClass> getVClassesForProperty(String vclassURI, String propertyURI, boolean domainSide) {
        ArrayList<VClass> vClasses = new ArrayList<VClass>();
        this.getOntModel().enterCriticalSection(true);
        try {
            ObjectProperty op = this.getOntModel().getObjectProperty(propertyURI);
            if (op != null) {
                List<String> superproperties;
                OntResource superclass = null;
                if (vclassURI != null) {
                    superproperties = this.getWebappDaoFactory().getObjectPropertyDao().getSuperPropertyURIs(propertyURI, false);
                    superproperties.add(propertyURI);
                    HashSet<String> subjSuperclasses = new HashSet<String>(this.getAllSuperClassURIs(vclassURI));
                    subjSuperclasses.add(vclassURI);
                    for (String objectPropertyURI : superproperties) {
                        StmtIterator restStmtIt = this.getOntModel().listStatements(null, OWL.onProperty, (RDFNode)this.getOntModel().getProperty(objectPropertyURI));
                        while (restStmtIt.hasNext()) {
                            Statement restStmt = (Statement)restStmtIt.next();
                            Resource restRes = restStmt.getSubject();
                            StmtIterator axStmtIt = this.getOntModel().listStatements(null, null, (RDFNode)restRes);
                            while (axStmtIt.hasNext()) {
                                AllValuesFromRestriction avfRest;
                                Resource avf;
                                Statement axStmt = (Statement)axStmtIt.next();
                                OntResource subjOntRes = null;
                                if (axStmt.getSubject().canAs(OntResource.class)) {
                                    subjOntRes = (OntResource)axStmt.getSubject().as(OntResource.class);
                                }
                                if (subjOntRes == null || !subjSuperclasses.contains(this.getClassURIStr((Resource)subjOntRes)) || !axStmt.getPredicate().equals(RDFS.subClassOf) && !axStmt.getPredicate().equals(OWL.equivalentClass) || !restRes.canAs(AllValuesFromRestriction.class) || !(avf = (avfRest = (AllValuesFromRestriction)restRes.as(AllValuesFromRestriction.class)).getAllValuesFrom()).canAs(OntClass.class)) continue;
                                superclass = (OntResource)avfRest.getAllValuesFrom().as(OntClass.class);
                            }
                        }
                    }
                }
                if (superclass == null) {
                    OntResource ontResource = superclass = domainSide ? op.getRange() : op.getDomain();
                    if (superclass == null) {
                        superproperties = Collections.emptyList();
                        return superproperties;
                    }
                }
                if (superclass != null) {
                    VClass superVclass = superclass.isAnon() ? this.getVClassByURI(this.getClassURIStr((Resource)superclass)) : this.getVClassByURI(superclass.getURI());
                    if (OWL.Thing.equals((Object)superclass)) {
                        List<VClass> list = Collections.emptyList();
                        return list;
                    }
                    if (superVclass != null) {
                        vClasses.add(superVclass);
                        if (!this.isUnderlyingStoreReasoned()) {
                            for (String classURI : this.getAllSubClassURIs(this.getClassURIStr((Resource)superclass))) {
                                VClass vClass = this.getVClassByURI(classURI);
                                if (vClass == null) continue;
                                vClasses.add(vClass);
                            }
                        }
                    }
                }
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return vClasses;
    }

    @Override
    public void addVClassesToGroup(VClassGroup group) {
        this.addVClassesToGroup(group, true);
    }

    @Override
    @Deprecated
    public void addVClassesToGroup(VClassGroup group, boolean includeUninstantiatedClasses) {
        this.addVClassesToGroup(group, includeUninstantiatedClasses, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public void addVClassesToGroup(VClassGroup group, boolean includeUninstantiatedClasses, boolean getIndividualCount) {
        this.getOntModel().enterCriticalSection(true);
        if (getIndividualCount) {
            group.setIndividualCount(this.getClassGroupInstanceCount(group));
        }
        try {
            if (group != null && group.getURI() != null) {
                Resource groupRes = ResourceFactory.createResource((String)group.getURI());
                AnnotationProperty inClassGroup = this.getOntModel().getAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup");
                if (inClassGroup != null) {
                    try (StmtIterator annotIt = this.getOntModel().listStatements((Resource)((OntClass)null), (Property)inClassGroup, (RDFNode)groupRes);){
                        while (annotIt.hasNext()) {
                            try {
                                OntModel aboxModel;
                                Statement annot = (Statement)annotIt.next();
                                Resource cls = annot.getSubject();
                                VClass vcw = this.getVClassByURI(cls.getURI());
                                if (vcw == null) continue;
                                boolean classIsInstantiated = false;
                                if (getIndividualCount) {
                                    aboxModel = this.getOntModelSelector().getABoxModel();
                                    aboxModel.enterCriticalSection(true);
                                    int count = 0;
                                    try {
                                        String countQueryStr = "SELECT COUNT(*) WHERE \n{ ?s a <" + cls.getURI() + "> } \n";
                                        Query countQuery = QueryFactory.create((String)countQueryStr, (Syntax)Syntax.syntaxARQ);
                                        QueryExecution qe = QueryExecutionFactory.create((Query)countQuery, (Model)aboxModel);
                                        ResultSet rs = qe.execSelect();
                                        count = Integer.parseInt(((Literal)rs.nextSolution().get(".1")).getLexicalForm());
                                    }
                                    finally {
                                        aboxModel.leaveCriticalSection();
                                    }
                                    vcw.setEntityCount(count);
                                    classIsInstantiated = count > 0;
                                } else if (!includeUninstantiatedClasses) {
                                    aboxModel = this.getOntModelSelector().getABoxModel();
                                    aboxModel.enterCriticalSection(true);
                                    try (StmtIterator countIt = aboxModel.listStatements(null, RDF.type, (RDFNode)cls);){
                                        if (countIt.hasNext()) {
                                            classIsInstantiated = true;
                                        }
                                    }
                                    finally {
                                        aboxModel.leaveCriticalSection();
                                    }
                                }
                                if (!includeUninstantiatedClasses && !classIsInstantiated) continue;
                                group.add(vcw);
                            }
                            catch (ClassCastException cce) {
                                log.error((Object)cce, (Throwable)cce);
                            }
                        }
                    }
                }
            }
            Collections.sort(group.getVitroClassList());
            return;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getClassGroupInstanceCount(VClassGroup vcg) {
        OntModel ontModel = this.getOntModel();
        ontModel.enterCriticalSection(true);
        int count = 0;
        try {
            String queryText = "SELECT COUNT( DISTINCT ?instance ) WHERE { \n      ?class <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup> <" + vcg.getURI() + "> .\n      ?instance a ?class .  \n}";
            Query countQuery = QueryFactory.create((String)queryText, (Syntax)Syntax.syntaxARQ);
            QueryExecution qe = QueryExecutionFactory.create((Query)countQuery, (Model)ontModel);
            ResultSet rs = qe.execSelect();
            count = Integer.parseInt(((Literal)rs.nextSolution().get(".1")).getLexicalForm());
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVClassesToGroups(List<VClassGroup> groups) {
        this.getOntModel().enterCriticalSection(true);
        try {
            if (groups != null) {
                for (VClassGroup g : groups) {
                    this.addVClassesToGroup(g);
                }
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertNewVClass(VClass cls, OntModel ontModel) throws InsertException {
        ontModel.enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            String errMsgStr = this.getWebappDaoFactory().checkURIForEditableEntity(cls.getURI());
            if (errMsgStr != null) {
                throw new InsertException(errMsgStr);
            }
            OntClass ontCls = ontModel.createClass(cls.getURI());
            try {
                if (cls.getName() != null && cls.getName().length() > 0) {
                    ontCls.setLabel(cls.getName(), this.getDefaultLanguage());
                } else {
                    ontCls.removeAll(RDFS.label);
                }
            }
            catch (Exception e) {
                log.error((Object)("error setting label for class " + cls.getURI()));
            }
            try {
                if (cls.getGroupURI() != null && cls.getGroupURI().length() > 0) {
                    String badURIErrorStr = this.checkURI(cls.getGroupURI());
                    if (badURIErrorStr == null) {
                        ontCls.addProperty((Property)this.IN_CLASSGROUP, (RDFNode)this.getOntModel().getResource(cls.getGroupURI()));
                    } else {
                        log.error((Object)badURIErrorStr);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("error linking class " + cls.getURI() + " to class group"));
            }
            this.updatePlainLiteralValue((OntResource)ontCls, (Property)this.SHORTDEF, cls.getShortDef());
            this.updatePlainLiteralValue((OntResource)ontCls, (Property)this.EXAMPLE_ANNOT, cls.getExample());
            this.updatePlainLiteralValue((OntResource)ontCls, (Property)this.DESCRIPTION_ANNOT, cls.getDescription());
            this.addPropertyIntValue((Resource)ontCls, (Property)this.DISPLAY_LIMIT, cls.getDisplayLimit(), (Model)ontModel);
            this.addPropertyIntValue((Resource)ontCls, (Property)this.DISPLAY_RANK_ANNOT, cls.getDisplayRank(), (Model)ontModel);
            ontCls.removeAll((Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT);
            if (this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT != null && cls.getHiddenFromDisplayBelowRoleLevel() != null) {
                try {
                    ontCls.addProperty((Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT, (RDFNode)ResourceFactory.createResource((String)cls.getHiddenFromDisplayBelowRoleLevel().getURI()));
                }
                catch (Exception e) {
                    log.error((Object)("error adding HiddenFromDisplayBelowRoleLevel annotation to class " + cls.getURI()));
                }
            }
            ontCls.removeAll((Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT);
            if (this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT != null && cls.getProhibitedFromUpdateBelowRoleLevel() != null) {
                try {
                    ontCls.addProperty((Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT, (RDFNode)ResourceFactory.createResource((String)cls.getProhibitedFromUpdateBelowRoleLevel().getURI()));
                }
                catch (Exception e) {
                    log.error((Object)("error adding ProhibitedFromUpdateBelowRoleLevel annotation to class " + cls.getURI()));
                }
            }
            ontCls.removeAll((Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT);
            if (this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT != null && cls.getHiddenFromPublishBelowRoleLevel() != null) {
                try {
                    ontCls.addProperty((Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT, (RDFNode)ResourceFactory.createResource((String)cls.getHiddenFromPublishBelowRoleLevel().getURI()));
                }
                catch (Exception e) {
                    log.error((Object)("error adding HiddenFromPublishBelowRoleLevel annotation to class " + cls.getURI()));
                }
            }
            this.addPropertyStringValue((Resource)ontCls, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT, cls.getCustomEntryForm(), (Model)ontModel);
            this.addPropertyStringValue((Resource)ontCls, (Property)this.PROPERTY_CUSTOMDISPLAYVIEWANNOT, cls.getCustomDisplayView(), (Model)ontModel);
            this.addPropertyStringValue((Resource)ontCls, (Property)this.PROPERTY_CUSTOMSHORTVIEWANNOT, cls.getCustomShortView(), (Model)ontModel);
            this.addPropertyStringValue((Resource)ontCls, (Property)this.PROPERTY_CUSTOMSEARCHVIEWANNOT, cls.getCustomSearchView(), (Model)ontModel);
            this.addPropertyFloatValue((Resource)ontCls, (Property)this.SEARCH_BOOST_ANNOT, cls.getSearchBoost(), (Model)ontModel);
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
        return 0;
    }

    @Override
    public void updateVClass(VClass cls) {
        this.updateVClass(cls, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVClass(VClass cls, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        ontModel.getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            OntClass ontCls = ontModel.getOntClass(cls.getURI());
            if (ontCls != null) {
                this.updateRDFSLabel((OntResource)ontCls, cls.getName());
                this.updatePropertyResourceURIValue((Resource)ontCls, (Property)this.IN_CLASSGROUP, cls.getGroupURI(), (Model)ontModel);
                this.updatePlainLiteralValue((OntResource)ontCls, (Property)this.SHORTDEF, cls.getShortDef());
                this.updatePlainLiteralValue((OntResource)ontCls, (Property)this.EXAMPLE_ANNOT, cls.getExample());
                this.updatePlainLiteralValue((OntResource)ontCls, (Property)this.DESCRIPTION_ANNOT, cls.getDescription());
                this.updatePropertyNonNegativeIntValue((Resource)ontCls, (Property)this.DISPLAY_LIMIT, cls.getDisplayLimit(), (Model)ontModel);
                this.updatePropertyNonNegativeIntValue((Resource)ontCls, (Property)this.DISPLAY_RANK_ANNOT, cls.getDisplayRank(), (Model)ontModel);
                this.updatePropertyFloatValue((Resource)ontCls, (Property)this.SEARCH_BOOST_ANNOT, cls.getSearchBoost(), (Model)ontModel);
                if (cls.getHiddenFromDisplayBelowRoleLevel() != null) {
                    this.updatePropertyResourceURIValue((Resource)ontCls, (Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT, cls.getHiddenFromDisplayBelowRoleLevel().getURI(), (Model)ontModel);
                }
                if (cls.getProhibitedFromUpdateBelowRoleLevel() != null) {
                    this.updatePropertyResourceURIValue((Resource)ontCls, (Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT, cls.getProhibitedFromUpdateBelowRoleLevel().getURI(), (Model)ontModel);
                }
                if (cls.getHiddenFromPublishBelowRoleLevel() != null) {
                    this.updatePropertyResourceURIValue((Resource)ontCls, (Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT, cls.getHiddenFromPublishBelowRoleLevel().getURI(), (Model)ontModel);
                }
                this.updatePropertyStringValue((Resource)ontCls, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT, cls.getCustomEntryForm(), (Model)ontModel);
                this.updatePropertyStringValue((Resource)ontCls, (Property)this.PROPERTY_CUSTOMDISPLAYVIEWANNOT, cls.getCustomDisplayView(), (Model)ontModel);
                this.updatePropertyStringValue((Resource)ontCls, (Property)this.PROPERTY_CUSTOMSHORTVIEWANNOT, cls.getCustomShortView(), (Model)ontModel);
                this.updatePropertyStringValue((Resource)ontCls, (Property)this.PROPERTY_CUSTOMSEARCHVIEWANNOT, cls.getCustomSearchView(), (Model)ontModel);
            } else {
                log.error((Object)("error: cannot find jena class " + cls.getURI() + " for updating"));
            }
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void deleteClasses2Classes(Classes2Classes c2c) {
        this.deleteClasses2Classes(c2c, this.getOntModelSelector().getTBoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClasses2Classes(Classes2Classes c2c, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        ontModel.getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            Model[] changeSet;
            OntClass subclass = this.getOntClass(ontModel, c2c.getSubclassURI());
            OntClass superclass = this.getOntClass(ontModel, c2c.getSuperclassURI());
            if (subclass == null || superclass == null) {
                log.warn((Object)("unable to delete " + c2c.getSubclassURI() + " rdfs:subClassOf " + c2c.getSuperclassURI()));
                if (subclass == null) {
                    log.warn((Object)(c2c.getSubclassURI() + " not found in the model."));
                }
                if (superclass == null) {
                    log.warn((Object)(c2c.getSuperclassURI() + " not found in the model."));
                }
                return;
            }
            Model removal = ModelFactory.createDefaultModel();
            Model additions = ModelFactory.createDefaultModel();
            removal.add(ontModel.listStatements((Resource)subclass, RDFS.subClassOf, (RDFNode)superclass));
            if (subclass.isAnon()) {
                changeSet = this.getSmartRemoval((OntResource)subclass, this.getOntModel());
                removal.add(changeSet[0]);
                additions.add(changeSet[1]);
            }
            if (superclass.isAnon()) {
                changeSet = this.getSmartRemoval((OntResource)superclass, this.getOntModel());
                removal.add(changeSet[0]);
                additions.add(changeSet[1]);
            }
            ontModel.remove(removal);
            ontModel.add(additions);
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void insertNewClasses2Classes(Classes2Classes c2c) {
        this.insertNewClasses2Classes(c2c, this.getOntModelSelector().getTBoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNewClasses2Classes(Classes2Classes c2c, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        ontModel.getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            Resource subclass = ontModel.getResource(c2c.getSubclassURI());
            Resource superclass = ontModel.getResource(c2c.getSuperclassURI());
            if (subclass != null && superclass != null) {
                ontModel.add(subclass, RDFS.subClassOf, (RDFNode)superclass);
            }
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public boolean isSubClassOf(VClass vc1, VClass vc2) {
        if (vc1 == null || vc2 == null) {
            return false;
        }
        return this.isSubClassOf(vc1.getURI(), vc2.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubClassOf(String vclassURI1, String vclassURI2) {
        if (vclassURI1 == null || vclassURI2 == null) {
            return false;
        }
        OntModel ontModel = this.getOntModel();
        try {
            ontModel.enterCriticalSection(true);
            Resource oc1 = ontModel.getResource(vclassURI1);
            Resource oc2 = ontModel.getResource(vclassURI2);
            boolean bl = ontModel.contains(oc1, RDFS.subClassOf, (RDFNode)oc2);
            return bl;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }
}

