/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class SimpleOntModelSelector
implements OntModelSelector {
    protected OntModel fullModel;
    protected OntModel aboxModel;
    protected OntModel applicationMetadataModel;
    protected OntModel tboxModel;
    protected OntModel userAccountsModel;
    protected OntModelSpec DEFAULT_ONT_MODEL_SPEC = OntModelSpec.OWL_MEM;
    protected OntModel displayModel;

    public SimpleOntModelSelector() {
        this.aboxModel = ModelFactory.createOntologyModel((OntModelSpec)this.DEFAULT_ONT_MODEL_SPEC);
        this.tboxModel = ModelFactory.createOntologyModel((OntModelSpec)this.DEFAULT_ONT_MODEL_SPEC);
        this.applicationMetadataModel = ModelFactory.createOntologyModel((OntModelSpec)this.DEFAULT_ONT_MODEL_SPEC);
        this.userAccountsModel = ModelFactory.createOntologyModel((OntModelSpec)this.DEFAULT_ONT_MODEL_SPEC);
        this.fullModel = ModelFactory.createOntologyModel((OntModelSpec)this.DEFAULT_ONT_MODEL_SPEC);
        this.fullModel.addSubModel((Model)this.aboxModel);
        this.fullModel.addSubModel((Model)this.tboxModel);
        this.fullModel.addSubModel((Model)this.applicationMetadataModel);
    }

    public SimpleOntModelSelector(OntModel ontModel) {
        this.fullModel = ontModel;
        this.aboxModel = ontModel;
        this.applicationMetadataModel = ontModel;
        this.tboxModel = ontModel;
        this.userAccountsModel = ontModel;
        this.displayModel = ontModel;
    }

    public void setABoxModel(OntModel m) {
        this.fullModel.enterCriticalSection(false);
        try {
            this.fullModel.removeSubModel((Model)this.aboxModel);
            this.aboxModel = m;
            this.fullModel.addSubModel((Model)this.aboxModel);
        }
        finally {
            this.fullModel.leaveCriticalSection();
        }
    }

    public void setApplicationMetadataModel(OntModel m) {
        this.fullModel.enterCriticalSection(false);
        try {
            this.fullModel.removeSubModel((Model)this.applicationMetadataModel);
            this.applicationMetadataModel = m;
            this.fullModel.addSubModel((Model)this.applicationMetadataModel);
        }
        finally {
            this.fullModel.leaveCriticalSection();
        }
    }

    public void setTBoxModel(OntModel m) {
        this.fullModel.enterCriticalSection(false);
        try {
            this.fullModel.removeSubModel((Model)this.tboxModel);
            this.tboxModel = m;
            this.fullModel.addSubModel((Model)this.tboxModel);
        }
        finally {
            this.fullModel.leaveCriticalSection();
        }
    }

    public void setFullModel(OntModel m) {
        m.addSubModel((Model)this.tboxModel);
        m.addSubModel((Model)this.aboxModel);
        m.addSubModel((Model)this.applicationMetadataModel);
        this.fullModel = m;
    }

    @Override
    public OntModel getABoxModel() {
        return this.aboxModel;
    }

    @Override
    public OntModel getApplicationMetadataModel() {
        return this.applicationMetadataModel;
    }

    @Override
    public OntModel getFullModel() {
        return this.fullModel;
    }

    @Override
    public OntModel getTBoxModel() {
        return this.tboxModel;
    }

    @Override
    public OntModel getUserAccountsModel() {
        return this.userAccountsModel;
    }

    public void setUserAccountsModel(OntModel userAccountsModel) {
        this.userAccountsModel = userAccountsModel;
    }

    public void setDisplayModel(OntModel displayModel) {
        this.displayModel = displayModel;
    }

    @Override
    public OntModel getDisplayModel() {
        return this.displayModel;
    }
}

