/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.IndividualDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.IndividualSDB;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactorySDB;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.UnionClass;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDFS;
import org.joda.time.DateTime;

public class IndividualDaoSDB
extends IndividualDaoJena {
    private DatasetWrapperFactory dwf;
    private WebappDaoFactorySDB.SDBDatasetMode datasetMode;
    private WebappDaoFactorySDB wadf;
    private static final Log log = LogFactory.getLog((String)IndividualDaoSDB.class.getName());
    private static final boolean SKIP_INITIALIZATION = true;

    public IndividualDaoSDB(DatasetWrapperFactory dwf, WebappDaoFactorySDB.SDBDatasetMode datasetMode, WebappDaoFactorySDB wadf) {
        super(wadf);
        this.dwf = dwf;
        this.datasetMode = datasetMode;
        this.wadf = wadf;
    }

    protected DatasetWrapper getDatasetWrapper() {
        return this.dwf.getDatasetWrapper();
    }

    protected Individual makeIndividual(String individualURI) {
        try {
            return new IndividualSDB(individualURI, this.dwf, this.datasetMode, this.wadf);
        }
        catch (IndividualSDB.IndividualNotFoundException e) {
            return null;
        }
        catch (Exception ex) {
            log.error((Object)"An error occurred trying to make an individual ", (Throwable)ex);
            if (StringUtils.isNotEmpty((CharSequence)individualURI)) {
                log.error((Object)("IndividualURI equals " + individualURI));
            } else {
                log.error((Object)"IndividualURI is null or empty");
            }
            return null;
        }
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getABoxModel();
    }

    public List getIndividualsByVClassURI(String vclassURI, int offset, int quantity) {
        Resource theClass;
        if (vclassURI == null) {
            return null;
        }
        List<Object> ents = new ArrayList();
        Resource resource = theClass = vclassURI.indexOf(this.PSEUDO_BNODE_NS) == 0 ? this.getOntModel().createResource(new AnonId(vclassURI.split("#")[1])) : ResourceFactory.createResource((String)vclassURI);
        if (theClass.isAnon() && theClass.canAs(UnionClass.class)) {
            UnionClass u = (UnionClass)theClass.as(UnionClass.class);
            for (OntClass operand : u.listOperands().toList()) {
                VClassJena vc = new VClassJena(operand, this.getWebappDaoFactory());
                ents.addAll(this.getIndividualsByVClass(vc));
            }
        } else {
            String[] graphVars = new String[]{"?g"};
            String filterStr = WebappDaoFactorySDB.getFilterBlock(graphVars, this.datasetMode);
            if (!StringUtils.isEmpty((CharSequence)filterStr)) {
                List<Individual> graphFilteredIndividualList = this.getGraphFilteredIndividualList(theClass, filterStr);
                List<Individual> unfilteredIndividualList = this.getIndividualList(theClass);
                Iterator<Individual> unfilteredIt = unfilteredIndividualList.iterator();
                for (Individual filt : graphFilteredIndividualList) {
                    Individual unfilt = unfilteredIt.next();
                    while (!unfilt.getURI().equals(filt.getURI())) {
                        unfilt = unfilteredIt.next();
                    }
                    ents.add(unfilt);
                }
            } else {
                ents = this.getIndividualList(theClass);
            }
        }
        Collections.sort(ents);
        if (quantity > 0 && offset > 0) {
            ArrayList<Individual> sublist = new ArrayList<Individual>();
            for (int i = offset - 1; i < offset - 1 + quantity; ++i) {
                sublist.add((Individual)ents.get(i));
            }
            return sublist;
        }
        return ents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Individual> getIndividualList(Resource theClass) {
        final ArrayList<Individual> ents = new ArrayList<Individual>();
        DatasetWrapper w = this.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        try {
            String query = "SELECT DISTINCT ?ind ?label WHERE { \n{   ?ind a <" + theClass.getURI() + "> } \nUNION { \n    ?ind a <" + theClass.getURI() + "> . \n    ?ind  <" + RDFS.label.getURI() + "> ?label \n} \n} ORDER BY ?ind ?label";
            RDFService rdfService = this.wadf.getRDFService();
            try {
                rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){
                    String uri = null;
                    String label = null;

                    @Override
                    protected void processQuerySolution(QuerySolution qs) {
                        Resource currRes = qs.getResource("ind");
                        if (currRes.isAnon()) {
                            return;
                        }
                        if (this.uri != null && !this.uri.equals(currRes.getURI())) {
                            try {
                                ents.add(IndividualDaoSDB.this.makeIndividual(this.uri, this.label));
                            }
                            catch (IndividualSDB.IndividualNotFoundException individualNotFoundException) {
                                // empty catch block
                            }
                            this.uri = currRes.getURI();
                            this.label = null;
                        } else if (this.uri == null) {
                            this.uri = currRes.getURI();
                        }
                        Literal labelLit = qs.getLiteral("label");
                        if (labelLit != null) {
                            this.label = labelLit.getLexicalForm();
                        }
                    }

                    @Override
                    protected void endProcessing() {
                        if (this.uri != null) {
                            try {
                                ents.add(IndividualDaoSDB.this.makeIndividual(this.uri, this.label));
                            }
                            catch (IndividualSDB.IndividualNotFoundException individualNotFoundException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            catch (RDFServiceException e) {
                log.debug((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            dataset.getLock().leaveCriticalSection();
            w.close();
        }
        return ents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Individual> getGraphFilteredIndividualList(Resource theClass, String filterStr) {
        final ArrayList<Individual> filteredIndividualList = new ArrayList<Individual>();
        DatasetWrapper w = this.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        try {
            String query = "SELECT DISTINCT ?ind WHERE { GRAPH ?g { \n{   ?ind a <" + theClass.getURI() + "> } \n  } \n" + filterStr + "} ORDER BY ?ind";
            RDFService rdfService = this.wadf.getRDFService();
            try {
                rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                    @Override
                    protected void processQuerySolution(QuerySolution qs) {
                        Resource currRes = qs.getResource("ind");
                        if (!currRes.isAnon()) {
                            try {
                                filteredIndividualList.add(IndividualDaoSDB.this.makeIndividual(currRes.getURI(), null));
                            }
                            catch (IndividualSDB.IndividualNotFoundException individualNotFoundException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            catch (RDFServiceException e) {
                log.debug((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            dataset.getLock().leaveCriticalSection();
            w.close();
        }
        return filteredIndividualList;
    }

    private Individual makeIndividual(String uri, String label) throws IndividualSDB.IndividualNotFoundException {
        IndividualSDB ent = new IndividualSDB(uri, this.dwf, this.datasetMode, this.wadf, true);
        ent.setName(label);
        ent.setRdfsLabel(label);
        return ent;
    }

    @Override
    public Individual getIndividualByURI(String entityURI) {
        if (entityURI == null || entityURI.length() == 0) {
            return null;
        }
        return this.makeIndividual(entityURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillIndividualsForObjectPropertyStatements(Individual entity) {
        this.getOntModel().enterCriticalSection(true);
        try {
            for (ObjectPropertyStatement e2e : entity.getObjectPropertyStatements()) {
                e2e.setSubject(this.makeIndividual(e2e.getSubjectURI()));
                e2e.setObject(this.makeIndividual(e2e.getObjectURI()));
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Individual> getIndividualsByDataProperty(String dataPropertyUri, String value) {
        OntModel fullModel = this.getOntModelSelector().getFullModel();
        Property prop = null;
        prop = RDFS.label.getURI().equals(dataPropertyUri) ? RDFS.label : fullModel.getProperty(dataPropertyUri);
        if (prop == null) {
            log.debug((Object)("Could not getIndividualsByDataProperty() because " + dataPropertyUri + "was not found in model."));
            return Collections.emptyList();
        }
        if (value == null) {
            log.debug((Object)"Could not getIndividualsByDataProperty() because value was null");
            return Collections.emptyList();
        }
        Literal litv1 = fullModel.createLiteral(value);
        Literal litv2 = fullModel.createTypedLiteral(value);
        Literal litv3 = fullModel.createLiteral(value, "EN");
        HashMap<String, Individual> individualsMap = new HashMap<String, Individual>();
        fullModel.enterCriticalSection(true);
        int count = 0;
        try {
            String subUri;
            Literal literal;
            Object v;
            RDFNode obj;
            Resource sub;
            Statement stmt;
            StmtIterator stmts = fullModel.listStatements((Resource)null, prop, (RDFNode)litv1);
            while (stmts.hasNext()) {
                ++count;
                stmt = stmts.nextStatement();
                sub = stmt.getSubject();
                if (sub == null || sub.isAnon() || sub.isLiteral() || (obj = stmt.getObject()) == null || !obj.isLiteral() || (v = (literal = (Literal)obj).getValue()) == null || individualsMap.containsKey(subUri = sub.getURI())) continue;
                individualsMap.put(subUri, this.makeIndividual(subUri));
            }
            stmts = fullModel.listStatements((Resource)null, prop, (RDFNode)litv2);
            while (stmts.hasNext()) {
                ++count;
                stmt = stmts.nextStatement();
                sub = stmt.getSubject();
                if (sub == null || sub.isAnon() || sub.isLiteral() || (obj = stmt.getObject()) == null || !obj.isLiteral() || (v = (literal = (Literal)obj).getValue()) == null || individualsMap.containsKey(subUri = sub.getURI())) continue;
                individualsMap.put(subUri, this.makeIndividual(subUri));
            }
            stmts = fullModel.listStatements((Resource)null, prop, (RDFNode)litv3);
            while (stmts.hasNext()) {
                ++count;
                stmt = stmts.nextStatement();
                sub = stmt.getSubject();
                if (sub == null || sub.isAnon() || sub.isLiteral() || (obj = stmt.getObject()) == null || !obj.isLiteral() || (v = (literal = (Literal)obj).getValue()) == null || individualsMap.containsKey(subUri = sub.getURI())) continue;
                individualsMap.put(subUri, this.makeIndividual(subUri));
            }
        }
        finally {
            fullModel.leaveCriticalSection();
        }
        ArrayList<Individual> rv = new ArrayList<Individual>(individualsMap.size());
        rv.addAll(individualsMap.values());
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAllIndividualUris() {
        LinkedList<String> list = new LinkedList<String>();
        String query = "SELECT DISTINCT ?ind WHERE { \n { ?ind <" + RDFS.label.getURI() + "> ?label }  UNION {   GRAPH ?g { ?ind <" + RDFS.label.getURI() + "> ?label } \n  FILTER (?g != <" + "http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata" + ">           && !regex(str(?g),\"tbox\")) \n  } }";
        Query q = QueryFactory.create((String)query);
        DatasetWrapper w = this.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        QueryExecution qe = QueryExecutionFactory.create((Query)q, (Dataset)dataset);
        try {
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                Resource res = rs.next().getResource("ind");
                if (res.isAnon()) continue;
                list.add(res.getURI());
            }
        }
        finally {
            qe.close();
            dataset.getLock().leaveCriticalSection();
            w.close();
        }
        return list;
    }

    private Iterator<Individual> getIndividualIterator(final List<String> individualURIs) {
        if (individualURIs.size() > 0) {
            log.info((Object)("Number of individuals from source: " + individualURIs.size()));
            return new Iterator<Individual>(){
                Iterator<String> innerIt;
                {
                    this.innerIt = individualURIs.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.innerIt.hasNext();
                }

                @Override
                public Individual next() {
                    String indURI = this.innerIt.next();
                    Individual ind = IndividualDaoSDB.this.makeIndividual(indURI);
                    if (ind != null) {
                        return ind;
                    }
                    return new IndividualImpl(indURI);
                }

                @Override
                public void remove() {
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getUpdatedSinceIterator(long updatedSince) {
        ArrayList<String> individualURIs = new ArrayList<String>();
        Date since = new DateTime(updatedSince).toDate();
        String sinceStr = this.xsdDateTimeFormat.format(since);
        this.getOntModel().enterCriticalSection(true);
        try {
            String queryStr = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>SELECT ?ent WHERE {      ?ent vitro:modTime ?modTime .     FILTER (xsd:dateTime(?modTime) >= \"" + sinceStr + "\"^^xsd:dateTime) }";
            Query query = QueryFactory.create((String)queryStr);
            try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.getOntModel());){
                ResultSet results = qe.execSelect();
                while (results.hasNext()) {
                    QuerySolution qs = results.next();
                    Resource res = (Resource)qs.get("?ent");
                    if (res.getURI() == null) continue;
                    individualURIs.add(res.getURI());
                }
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return individualURIs.iterator();
    }
}

