/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.ArrayList;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class BlankNodeFilteringGraph
implements Graph {
    private Graph graph;

    public Graph getInnerGraph() {
        return this.graph;
    }

    public BlankNodeFilteringGraph(Graph graph) {
        this.graph = graph;
    }

    public void add(Triple t) throws AddDeniedException {
        this.graph.add(t);
    }

    public void close() {
        this.graph.close();
    }

    public boolean contains(Node arg0, Node arg1, Node arg2) {
        return this.graph.contains(arg0, arg1, arg2);
    }

    public boolean contains(Triple arg0) {
        return this.graph.contains(arg0);
    }

    public void delete(Triple t) throws DeleteDeniedException {
        this.graph.delete(t);
    }

    public ExtendedIterator<Triple> find(Triple triple) {
        return this.find(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean dependsOn(Graph arg0) {
        return this.graph.dependsOn(arg0);
    }

    public ExtendedIterator<Triple> find(Node subject, Node predicate, Node object) {
        ArrayList<Triple> nbTripList = new ArrayList<Triple>();
        ExtendedIterator triples = this.graph.find(subject, predicate, object);
        while (triples.hasNext()) {
            Triple triple = (Triple)triples.next();
            if (triple.getSubject().isBlank() || triple.getObject().isBlank()) continue;
            nbTripList.add(triple);
        }
        return WrappedIterator.create(nbTripList.iterator());
    }

    public Capabilities getCapabilities() {
        return this.graph.getCapabilities();
    }

    public GraphEventManager getEventManager() {
        return this.graph.getEventManager();
    }

    public PrefixMapping getPrefixMapping() {
        return this.graph.getPrefixMapping();
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        return this.graph.getStatisticsHandler();
    }

    public TransactionHandler getTransactionHandler() {
        return this.graph.getTransactionHandler();
    }

    public boolean isClosed() {
        return this.graph.isClosed();
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public boolean isIsomorphicWith(Graph arg0) {
        return this.graph.isIsomorphicWith(arg0);
    }

    public int size() {
        return this.graph.size();
    }

    public void clear() {
        this.graph.clear();
    }

    public void remove(Node arg0, Node arg1, Node arg2) {
        this.graph.remove(arg0, arg1, arg2);
    }

    public String toString() {
        return "BlankNodeFilteringGraph[" + ToString.hashHex(this) + ", inner=" + ToString.graphToString(this.graph) + "]";
    }
}

