/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.ObjectPropertyFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.WebappDaoFactoryFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.ontology.DatatypeProperty;

public class PropertyGroupDaoFiltering
implements PropertyGroupDao {
    final PropertyGroupDao innerDao;
    final WebappDaoFactoryFiltering filteredDaos;
    final VitroFilters filters;

    public PropertyGroupDaoFiltering(PropertyGroupDao propertyGroupDao, WebappDaoFactoryFiltering webappDaoFactoryFiltering, VitroFilters filters) {
        this.innerDao = propertyGroupDao;
        this.filteredDaos = webappDaoFactoryFiltering;
        this.filters = filters;
    }

    @Override
    public void deletePropertyGroup(PropertyGroup group) {
        this.innerDao.deletePropertyGroup(group);
    }

    @Override
    public PropertyGroup getGroupByURI(String uri) {
        PropertyGroup grp = this.innerDao.getGroupByURI(uri);
        this.wrapPropertyGroup(grp);
        return grp;
    }

    private void wrapPropertyGroup(PropertyGroup grp) {
        if (grp == null) {
            return;
        }
        List<Property> props = grp.getPropertyList();
        if (props == null || props.size() == 0) {
            return;
        }
        LinkedList<Property> filteredProps = new LinkedList<Property>();
        for (Property prop : props) {
            if (prop == null) continue;
            if (prop instanceof ObjectProperty) {
                if (!((Boolean)this.filters.getObjectPropertyFilter().fn((Object)((ObjectProperty)prop))).booleanValue()) continue;
                filteredProps.add(new ObjectPropertyFiltering((ObjectProperty)prop, this.filters));
                continue;
            }
            if (prop instanceof ObjectPropertyFiltering) {
                if (!((Boolean)this.filters.getObjectPropertyFilter().fn((Object)((ObjectProperty)prop))).booleanValue()) continue;
                filteredProps.add(new ObjectPropertyFiltering((ObjectProperty)prop, this.filters));
                continue;
            }
            if (!(prop instanceof DatatypeProperty) || !((Boolean)this.filters.getDataPropertyFilter().fn((Object)((DataProperty)prop))).booleanValue()) continue;
            filteredProps.add(prop);
        }
        grp.setPropertyList(filteredProps);
    }

    @Override
    public List<PropertyGroup> getPublicGroups(boolean withProperties) {
        List<PropertyGroup> groups = this.innerDao.getPublicGroups(withProperties);
        for (PropertyGroup grp : groups) {
            this.wrapPropertyGroup(grp);
        }
        return groups;
    }

    @Override
    public PropertyGroup createDummyPropertyGroup(String name, int rank) {
        return this.innerDao.createDummyPropertyGroup(name, rank);
    }

    @Override
    public String insertNewPropertyGroup(PropertyGroup group) {
        return this.innerDao.insertNewPropertyGroup(group);
    }

    @Override
    public int removeUnpopulatedGroups(List<PropertyGroup> groups) {
        return this.innerDao.removeUnpopulatedGroups(groups);
    }

    @Override
    public void updatePropertyGroup(PropertyGroup group) {
        this.innerDao.updatePropertyGroup(group);
    }
}

