/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonObjectProducer;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetAllVClasses
extends JsonObjectProducer {
    private static final Log log = LogFactory.getLog(GetAllVClasses.class);

    public GetAllVClasses(VitroRequest vreq) {
        super(vreq);
    }

    @Override
    protected ObjectNode process() throws Exception {
        ObjectNode map = JsonNodeFactory.instance.objectNode();
        ArrayList<VClass> vclasses = new ArrayList<VClass>();
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)this.vreq);
        List<VClassGroup> groups = vcgc.getGroups();
        for (VClassGroup vcg : groups) {
            vclasses.addAll(vcg);
        }
        Collections.sort(vclasses);
        ArrayNode classes = JsonNodeFactory.instance.arrayNode();
        for (VClass vc : vclasses) {
            ObjectNode vcObj = JsonNodeFactory.instance.objectNode();
            vcObj.put("name", vc.getName());
            vcObj.put("URI", vc.getURI());
            classes.add((JsonNode)vcObj);
        }
        map.put("classes", (JsonNode)classes);
        return map;
    }
}

