/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individuallist;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.util.Collection;
import java.util.Map;

public class IndividualJsonWrapper {
    private static AddJSONFields addJSONFields = null;

    public static void setAddJSONFields(AddJSONFields add) {
        addJSONFields = add;
    }

    static ObjectNode packageIndividualAsJson(VitroRequest vreq, Individual ind) {
        WebappDaoFactory fullWdf = vreq.getUnfilteredWebappDaoFactory();
        ObjectNode jo = JsonNodeFactory.instance.objectNode();
        jo.put("URI", ind.getURI());
        jo.put("label", ind.getRdfsLabel());
        jo.put("name", ind.getName());
        jo.put("thumbUrl", ind.getThumbUrl());
        jo.put("imageUrl", ind.getImageUrl());
        jo.put("profileUrl", UrlBuilder.getIndividualProfileUrl(ind, vreq));
        ArrayNode ao = JsonNodeFactory.instance.arrayNode();
        for (String type : IndividualJsonWrapper.getMostSpecificTypes(ind, fullWdf)) {
            ao.add(type);
        }
        jo.put("mostSpecificTypes", (JsonNode)ao);
        if (addJSONFields != null) {
            addJSONFields.add(jo, vreq, ind);
        }
        return jo;
    }

    public static Collection<String> getMostSpecificTypes(Individual individual, WebappDaoFactory wdf) {
        ObjectPropertyStatementDao opsDao = wdf.getObjectPropertyStatementDao();
        Map<String, String> mostSpecificTypes = opsDao.getMostSpecificTypesInClassgroupsForIndividual(individual.getURI());
        return mostSpecificTypes.values();
    }

    public static interface AddJSONFields {
        public void add(ObjectNode var1, VitroRequest var2, Individual var3);
    }
}

