/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class IndividualTemplateLocator {
    private static final Log log = LogFactory.getLog(IndividualTemplateLocator.class);
    private static final String TEMPLATE_INDIVIDUAL_DEFAULT = "individual.ftl";
    private final VitroRequest vreq;
    private final ServletContext ctx;
    private final Individual individual;

    public IndividualTemplateLocator(VitroRequest vreq, Individual individual) {
        this.vreq = vreq;
        this.ctx = vreq.getSession().getServletContext();
        this.individual = individual;
    }

    String findTemplate() {
        String vclassName = "unknown";
        String customTemplate = null;
        if (this.individual.getVClass() != null) {
            vclassName = this.individual.getVClass().getName();
            List<VClass> directClasses = this.individual.getVClasses(true);
            for (VClass vclass : directClasses) {
                customTemplate = vclass.getCustomDisplayView();
                if (customTemplate == null) continue;
                if (customTemplate.length() > 0) {
                    vclassName = vclass.getName();
                    log.debug((Object)("Found direct class [" + vclass.getName() + "] with custom view " + customTemplate + "; resetting entity vclassName to this class"));
                    break;
                }
                customTemplate = null;
            }
            if (customTemplate == null) {
                List<VClass> inferredClasses = this.individual.getVClasses(false);
                for (VClass vclass : inferredClasses) {
                    customTemplate = vclass.getCustomDisplayView();
                    if (customTemplate == null) continue;
                    if (customTemplate.length() > 0) {
                        log.debug((Object)("Found inferred class [" + vclass.getName() + "] with custom view " + customTemplate));
                        break;
                    }
                    customTemplate = null;
                }
            }
            SimpleReasoner simpleReasoner = (SimpleReasoner)this.ctx.getAttribute(SimpleReasoner.class.getName());
            if (customTemplate == null && simpleReasoner != null && simpleReasoner.isABoxReasoningAsynchronous()) {
                log.debug((Object)"Checking superclasses for custom template specification because ABox reasoning is asynchronous");
                block2: for (VClass directVClass : directClasses) {
                    VClassDao vcDao = this.vreq.getWebappDaoFactory().getVClassDao();
                    List<String> superClassUris = vcDao.getAllSuperClassURIs(directVClass.getURI());
                    for (String uri : superClassUris) {
                        VClass vclass = vcDao.getVClassByURI(uri);
                        customTemplate = vclass.getCustomDisplayView();
                        if (customTemplate == null) continue;
                        if (customTemplate.length() > 0) {
                            log.debug((Object)("Found superclass [" + vclass.getName() + "] with custom view " + customTemplate));
                            continue block2;
                        }
                        customTemplate = null;
                    }
                }
            }
        } else if (this.individual.getVClassURI() != null) {
            log.debug((Object)("Individual " + this.individual.getURI() + " with class URI " + this.individual.getVClassURI() + ": no class found with that URI"));
        }
        return customTemplate != null ? customTemplate : TEMPLATE_INDIVIDUAL_DEFAULT;
    }
}

