/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.edit.listing.ListingControllerWebUtils;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.util.ArrayList;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="DataPropertyStatementListingController", urlPatterns={"/listDataPropertyStatements"})
public class DataPropertyStatementListingController
extends BaseEditController {
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vrequest = new VitroRequest(request);
        String noResultsMsgStr = "No data properties found";
        int startAt = 1;
        String startAtParam = request.getParameter("startAt");
        if (startAtParam != null && startAtParam.trim().length() > 0) {
            try {
                startAt = Integer.parseInt(startAtParam);
                if (startAt <= 0) {
                    startAt = 1;
                }
            }
            catch (NumberFormatException ex) {
                throw new Error("Cannot interpret " + startAtParam + " as a number");
            }
        }
        int endAt = 50;
        String endAtParam = request.getParameter("endAt");
        if (endAtParam != null && endAtParam.trim().length() > 0) {
            try {
                endAt = Integer.parseInt(endAtParam);
                if (endAt <= 0) {
                    endAt = 1;
                }
                if (endAt < startAt) {
                    int temp = startAt;
                    startAt = endAt;
                    endAt = temp;
                }
            }
            catch (NumberFormatException ex) {
                throw new Error("Cannot interpret " + endAtParam + " as a number");
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        request.setAttribute("results", results);
        results.add("XX");
        results.add("subject");
        results.add("property");
        results.add("object");
        DataPropertyStatementDao dpsDao = vrequest.getUnfilteredWebappDaoFactory().getDataPropertyStatementDao();
        DataPropertyDao dpDao = vrequest.getUnfilteredWebappDaoFactory().getDataPropertyDao();
        IndividualDao iDao = vrequest.getUnfilteredWebappDaoFactory().getIndividualDao();
        String propURIStr = request.getParameter("propertyURI");
        DataProperty dp = dpDao.getDataPropertyByURI(propURIStr);
        int count = 0;
        for (DataPropertyStatement dataPropertyStatement : dpsDao.getDataPropertyStatements(dp, startAt, endAt)) {
            ++count;
            DataPropertyStatement dps = dataPropertyStatement;
            Individual subj = iDao.getIndividualByURI(dps.getIndividualURI());
            results.add("XX");
            results.add(ListingControllerWebUtils.formatIndividualLink(subj));
            results.add(dp.getPublicName());
            results.add(dps.getData());
        }
        if (count == 0) {
            results.add("XX");
            results.add("No statements found for property \"" + dp.getPublicName() + "\"");
            results.add("");
            results.add("");
        }
        request.setAttribute("columncount", (Object)new Integer(4));
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)"Data Property Statements");
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/fetch/horizontal.jsp");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
    }
}

