/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Classes2Classes;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="Classes2ClassesOperationController", urlPatterns={"/classes2ClassesOp"})
public class Classes2ClassesOperationController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)Classes2ClassesOperationController.class.getName());

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse response) {
        String referer;
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        String defaultLandingPage = this.getDefaultLandingPage((HttpServletRequest)request);
        HashMap epoHash = null;
        EditProcessObject epo = null;
        try {
            epoHash = (HashMap)request.getSession().getAttribute("epoHash");
            epo = (EditProcessObject)epoHash.get(request.getParameter("_epoKey"));
        }
        catch (NullPointerException e) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException f) {
                log.error((Object)f, (Throwable)f);
                throw new RuntimeException(f);
            }
            return;
        }
        if (epo == null) {
            log.debug((Object)"null epo");
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            return;
        }
        VClassDao vcDao = request.getLanguageNeutralWebappDaoFactory().getVClassDao();
        String modeStr = request.getParameter("opMode");
        String string = modeStr = modeStr == null ? "" : modeStr;
        if (request.getParameter("_cancel") == null) {
            try {
                if (request.getParameter("operation").equals("remove")) {
                    Object subclassURIstrs = request.getParameterValues("SubclassURI");
                    if (subclassURIstrs != null && ((String[])subclassURIstrs).length > 1) {
                        String superclassURIstr = request.getParameter("SuperclassURI");
                        if (superclassURIstr != null) {
                            block36: for (Object subclassURIstr : subclassURIstrs) {
                                switch (modeStr) {
                                    case "disjointWith": {
                                        vcDao.removeDisjointWithClass(superclassURIstr, (String)subclassURIstr);
                                        continue block36;
                                    }
                                    case "equivalentClass": {
                                        vcDao.removeEquivalentClass(superclassURIstr, (String)subclassURIstr);
                                        continue block36;
                                    }
                                    default: {
                                        Classes2Classes c2c = new Classes2Classes();
                                        c2c.setSubclassURI((String)subclassURIstr);
                                        c2c.setSuperclassURI(superclassURIstr);
                                        vcDao.deleteClasses2Classes(c2c);
                                    }
                                }
                            }
                        }
                    } else {
                        String subclassURIstr = subclassURIstrs[0];
                        String[] superclassURIstrs = request.getParameterValues("SuperclassURI");
                        if (superclassURIstrs != null) {
                            block37: for (String superclassURIstr : superclassURIstrs) {
                                switch (modeStr) {
                                    case "disjointWith": {
                                        vcDao.removeDisjointWithClass(superclassURIstr, subclassURIstr);
                                        continue block37;
                                    }
                                    case "equivalentClass": {
                                        vcDao.removeEquivalentClass(subclassURIstr, superclassURIstr);
                                        continue block37;
                                    }
                                    default: {
                                        Classes2Classes c2c = new Classes2Classes();
                                        c2c.setSuperclassURI(superclassURIstr);
                                        c2c.setSubclassURI(subclassURIstr);
                                        vcDao.deleteClasses2Classes(c2c);
                                    }
                                }
                            }
                        }
                    }
                } else if (request.getParameter("operation").equals("add")) {
                    switch (modeStr) {
                        case "disjointWith": {
                            vcDao.addDisjointWithClass(request.getParameter("SuperclassURI"), request.getParameter("SubclassURI"));
                            break;
                        }
                        case "equivalentClass": {
                            vcDao.addEquivalentClass(request.getParameter("SuperclassURI"), request.getParameter("SubclassURI"));
                            break;
                        }
                        default: {
                            Classes2Classes c2c = new Classes2Classes();
                            c2c.setSuperclassURI(request.getParameter("SuperclassURI"));
                            c2c.setSubclassURI(request.getParameter("SubclassURI"));
                            vcDao.insertNewClasses2Classes(c2c);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if ((referer = epo.getReferer()) == null) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            response.sendRedirect(referer);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }
}

