/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpRestoreController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;

abstract class AbstractDumpRestoreAction {
    protected final HttpServletRequest req;

    public AbstractDumpRestoreAction(HttpServletRequest req) {
        this.req = req;
    }

    protected RDFService getRdfService(ModelAccess.WhichService which) {
        return RDFServiceUtils.getRDFService(new VitroRequest(this.req), which);
    }

    protected <T extends Enum<T>> T getEnumFromParameter(Class<T> enumClass, String key) throws DumpRestoreController.BadRequestException {
        String valueString = this.req.getParameter(key);
        if (valueString == null) {
            throw new DumpRestoreController.BadRequestException("Request has no '" + key + "' parameter. ");
        }
        try {
            return Enum.valueOf(enumClass, valueString);
        }
        catch (Exception e) {
            throw new DumpRestoreController.BadRequestException("Request has invalid '" + key + "' parameter: '" + valueString + "'; acceptable values are " + EnumSet.allOf(enumClass));
        }
    }
}

