/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.BasicAuthenticator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RestrictedAuthenticator
extends Authenticator {
    private final HttpServletRequest req;
    private final Authenticator auth;

    public RestrictedAuthenticator(HttpServletRequest req, Authenticator auth) {
        this.req = req;
        this.auth = auth;
    }

    @Override
    public boolean isUserPermittedToLogin(UserAccount userAccount) {
        if (userAccount == null) {
            return false;
        }
        ArrayIdentifierBundle ids = new ArrayIdentifierBundle(new Identifier[0]);
        ids.addAll(RestrictedAuthenticator.getIdsForUserAccount(this.req, userAccount));
        ids.addAll(RequestIdentifiers.getIdBundleForRequest((ServletRequest)this.req));
        return PolicyHelper.isAuthorizedForActions(ids, ServletPolicyList.getPolicies(this.req), (AuthorizationRequest)SimplePermission.LOGIN_DURING_MAINTENANCE.ACTION);
    }

    @Override
    public void recordLoginAgainstUserAccount(UserAccount userAccount, LoginStatusBean.AuthenticationSource authSource) throws Authenticator.LoginNotPermitted {
        if (!this.isUserPermittedToLogin(userAccount)) {
            throw new Authenticator.LoginNotPermitted();
        }
        this.auth.recordLoginAgainstUserAccount(userAccount, authSource);
    }

    @Override
    public UserAccount getAccountForExternalAuth(String externalAuthId) {
        return this.auth.getAccountForExternalAuth(externalAuthId);
    }

    @Override
    public UserAccount getAccountForInternalAuth(String emailAddress) {
        return this.auth.getAccountForInternalAuth(emailAddress);
    }

    @Override
    public boolean md5HashIsNull(UserAccount userAccount) {
        return userAccount.getMd5Password().compareTo("") == 0 || userAccount.getMd5Password() == null;
    }

    @Override
    public boolean isCurrentPasswordArgon2(UserAccount userAccount, String clearTextPassword) {
        if (userAccount == null) {
            return false;
        }
        if (clearTextPassword == null) {
            return false;
        }
        return RestrictedAuthenticator.verifyArgon2iHash(userAccount.getArgon2Password(), clearTextPassword);
    }

    @Override
    public boolean isCurrentPassword(UserAccount userAccount, String clearTextPassword) {
        return this.auth.isCurrentPassword(userAccount, clearTextPassword);
    }

    @Override
    public void recordNewPassword(UserAccount userAccount, String newClearTextPassword) {
        this.auth.recordNewPassword(userAccount, newClearTextPassword);
    }

    @Override
    public boolean accountRequiresEditing(UserAccount userAccount) {
        return this.auth.accountRequiresEditing(userAccount);
    }

    @Override
    public List<String> getAssociatedIndividualUris(UserAccount userAccount) {
        return this.auth.getAssociatedIndividualUris(userAccount);
    }

    @Override
    public void recordUserIsLoggedOut() {
        this.auth.recordUserIsLoggedOut();
    }

    public String toString() {
        return "RestrictedAuthenticator[" + this.auth + "]";
    }

    public static class Factory
    implements Authenticator.AuthenticatorFactory {
        @Override
        public Authenticator getInstance(HttpServletRequest req) {
            return new RestrictedAuthenticator(req, new BasicAuthenticator(req));
        }
    }
}

