/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public enum ResultSetMediaType {
    TEXT("text/plain", true, "TEXT", null, "txt"),
    CSV("text/csv", true, "CSV", null, "csv"),
    TSV("text/tab-separated-values", false, "CSV", "tsv", "tsv"),
    XML("application/sparql-results+xml", true, "XML", null, "xml"),
    JSON("application/sparql-results+json", true, "JSON", null, "json");

    private static final Map<String, ResultSetMediaType> contentTypesMap;
    private final String contentType;
    private final boolean nativeFormat;
    private final String rdfServiceFormat;
    private final String jenaResponseFormat;
    private final String extension;

    private static Map<String, ResultSetMediaType> buildMap() {
        LinkedHashMap<String, ResultSetMediaType> map = new LinkedHashMap<String, ResultSetMediaType>();
        for (ResultSetMediaType value : ResultSetMediaType.values()) {
            map.put(value.contentType, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public static Collection<String> contentTypes() {
        return contentTypesMap.keySet();
    }

    public static ResultSetMediaType fromContentType(String contentType) throws IllegalArgumentException {
        ResultSetMediaType type = contentTypesMap.get(contentType);
        if (type == null) {
            throw new IllegalArgumentException("No ResultSetMediaType has contentType='" + contentType + "'");
        }
        return type;
    }

    private ResultSetMediaType(String contentType, boolean nativeFormat, String rdfServiceFormat, String jenaResponseFormat, String extension) {
        this.contentType = contentType;
        this.nativeFormat = nativeFormat;
        this.rdfServiceFormat = rdfServiceFormat;
        this.jenaResponseFormat = jenaResponseFormat;
        this.extension = extension;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isNativeFormat() {
        return this.nativeFormat;
    }

    public String getRdfServiceFormat() {
        return this.rdfServiceFormat;
    }

    public String getJenaResponseFormat() {
        return this.jenaResponseFormat;
    }

    public String getExtension() {
        return this.extension;
    }

    static {
        contentTypesMap = ResultSetMediaType.buildMap();
    }
}

