/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.ajax;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ExternalAuthChecker
extends AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog(ExternalAuthChecker.class);
    private static final String PARAMETER_USER_ACCOUNT_URI = "userAccountUri";
    private static final String PARAMETER_ETERNAL_AUTH_ID = "externalAuthId";
    private static final String RESPONSE_ID_IN_USE = "idInUse";
    private static final String RESPONSE_MATCHES_PROFILE = "matchesProfile";
    private static final String RESPONSE_PROFILE_URI = "profileUri";
    private static final String RESPONSE_PROFILE_URL = "profileUrl";
    private static final String RESPONSE_PROFILE_LABEL = "profileLabel";
    private final String userAccountUri = this.getStringParameter("userAccountUri", "");
    private final String externalAuthId = this.getStringParameter("externalAuthId", "");
    private Individual matchingProfile;

    public ExternalAuthChecker(HttpServlet parent, VitroRequest vreq, HttpServletResponse resp) {
        super(parent, vreq, resp);
    }

    @Override
    public String prepareResponse() throws IOException {
        if (this.someoneElseIsUsingThisExternalAuthId()) {
            return this.respondExternalAuthIdAlreadyUsed();
        }
        this.checkForMatchingProfile();
        if (this.matchingProfile != null) {
            return this.respondWithMatchingProfile();
        }
        return "[]";
    }

    private boolean someoneElseIsUsingThisExternalAuthId() {
        if (this.externalAuthId.isEmpty()) {
            log.debug((Object)"externalAuthId is empty.");
            return false;
        }
        UserAccount user = this.uaDao.getUserAccountByExternalAuthId(this.externalAuthId);
        if (user == null) {
            log.debug((Object)("no user account has externalAuthId='" + this.externalAuthId + "'"));
            return false;
        }
        if (user.getUri().equals(this.userAccountUri)) {
            log.debug((Object)("externalAuthId '" + this.externalAuthId + "' belongs to current user '" + this.userAccountUri + "'"));
            return false;
        }
        log.debug((Object)(user.getEmailAddress() + " is already using externalAuthId '" + this.externalAuthId + "'"));
        return true;
    }

    private String respondExternalAuthIdAlreadyUsed() {
        ObjectNode jsonObject = JsonNodeFactory.instance.objectNode();
        jsonObject.put(RESPONSE_ID_IN_USE, true);
        return jsonObject.toString();
    }

    private void checkForMatchingProfile() {
        List<Individual> inds = SelfEditingConfiguration.getBean((ServletRequest)this.vreq).getAssociatedIndividuals(this.indDao, this.externalAuthId);
        if (inds.isEmpty()) {
            log.debug((Object)("No profiles match '" + this.externalAuthId + "'"));
            return;
        }
        this.matchingProfile = inds.get(0);
    }

    private String respondWithMatchingProfile() {
        String uri = this.matchingProfile.getURI();
        String url = UrlBuilder.getIndividualProfileUrl(uri, this.vreq);
        String label = this.matchingProfile.getRdfsLabel();
        ObjectNode jsonObject = JsonNodeFactory.instance.objectNode();
        jsonObject.put(RESPONSE_MATCHES_PROFILE, true);
        jsonObject.put(RESPONSE_PROFILE_URI, uri);
        jsonObject.put(RESPONSE_PROFILE_URL, url);
        jsonObject.put(RESPONSE_PROFILE_LABEL, label);
        return jsonObject.toString();
    }
}

