/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.usepages.ManageRootAccount;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsOrdering;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelection;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelectionCriteria;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelector;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAccountsListPage
extends UserAccountsPage {
    private static final Log log = LogFactory.getLog(UserAccountsListPage.class);
    public static final String PARAMETER_ACCOUNTS_PER_PAGE = "accountsPerPage";
    public static final String PARAMETER_PAGE_INDEX = "pageIndex";
    public static final String PARAMETER_ORDERING_DIRECTION = "orderDirection";
    public static final String PARAMETER_ORDERING_FIELD = "orderField";
    public static final String PARAMETER_ROLE_FILTER_URI = "roleFilterUri";
    public static final String PARAMETER_SEARCH_TERM = "searchTerm";
    public static final String PARAMETER_NEW_USER_URI = "newUserUri";
    public static final String PARAMETER_UPDATED_USER_URI = "updatedUserUri";
    public static final String FLAG_UPDATED_USER_PW = "updatedUserPw";
    public static final String FLAG_USERS_DELETED = "usersDeleted";
    private static final String TEMPLATE_NAME = "userAccounts-list.ftl";
    private UserAccountsSelectionCriteria criteria = UserAccountsSelectionCriteria.DEFAULT_CRITERIA;

    public UserAccountsListPage(VitroRequest vreq) {
        super(vreq);
        this.parseParameters();
    }

    private void parseParameters() {
        int accountsPerPage = this.getIntegerParameter(PARAMETER_ACCOUNTS_PER_PAGE, 25);
        int pageIndex = this.getIntegerParameter(PARAMETER_PAGE_INDEX, 1);
        UserAccountsOrdering.Direction orderingDirection = UserAccountsOrdering.Direction.fromKeyword(this.vreq.getParameter(PARAMETER_ORDERING_DIRECTION));
        UserAccountsOrdering.Field orderingField = UserAccountsOrdering.Field.fromName(this.vreq.getParameter(PARAMETER_ORDERING_FIELD));
        UserAccountsOrdering ordering = new UserAccountsOrdering(orderingField, orderingDirection);
        String roleFilterUri = this.getStringParameter(PARAMETER_ROLE_FILTER_URI, "");
        String searchTerm = this.getStringParameter(PARAMETER_SEARCH_TERM, "");
        this.criteria = new UserAccountsSelectionCriteria(accountsPerPage, pageIndex, ordering, roleFilterUri, searchTerm);
        log.debug((Object)("selection criteria is: " + this.criteria));
    }

    public ResponseValues showPage() {
        UserAccountsSelection selection = UserAccountsSelector.select(this.userAccountsModel, this.criteria);
        Map<String, Object> body = this.buildTemplateBodyMap(selection);
        Message.applyToBodyMap((HttpServletRequest)this.vreq, body);
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private Map<String, Object> buildTemplateBodyMap(UserAccountsSelection selection) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put(PARAMETER_ACCOUNTS_PER_PAGE, this.criteria.getAccountsPerPage());
        body.put(PARAMETER_PAGE_INDEX, this.criteria.getPageIndex());
        body.put(PARAMETER_ORDERING_DIRECTION, this.criteria.getOrderBy().getDirection().keyword);
        body.put(PARAMETER_ORDERING_FIELD, this.criteria.getOrderBy().getField().name);
        body.put(PARAMETER_ROLE_FILTER_URI, this.criteria.getRoleFilterUri());
        body.put(PARAMETER_SEARCH_TERM, this.criteria.getSearchTerm());
        body.put("accounts", this.wrapUserAccounts(selection));
        body.put("total", selection.getResultCount());
        body.put("page", this.buildPageMap(selection));
        body.put("formUrls", this.buildUrlsMap());
        body.put("roles", this.buildListOfSelectableRoles());
        body.put("messages", this.buildMessagesMap());
        return body;
    }

    private Map<String, Integer> buildPageMap(UserAccountsSelection selection) {
        int currentPage = selection.getCriteria().getPageIndex();
        float pageCount = (float)selection.getResultCount() / (float)selection.getCriteria().getAccountsPerPage();
        int lastPage = (int)Math.ceil(pageCount);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("current", currentPage);
        map.put("first", 1);
        map.put("last", lastPage);
        if (currentPage < lastPage) {
            map.put("next", currentPage + 1);
        }
        if (currentPage > 1) {
            map.put("previous", currentPage - 1);
        }
        return map;
    }

    private Map<String, Object> buildMessagesMap() {
        UserAccount updatedUser;
        HashMap<String, Object> map = new HashMap<String, Object>();
        UserAccount newUser = this.getUserFromUriParameter(PARAMETER_NEW_USER_URI);
        if (newUser != null) {
            map.put("newUser", newUser);
        }
        if ((updatedUser = this.getUserFromUriParameter(PARAMETER_UPDATED_USER_URI)) != null) {
            map.put("updatedUser", updatedUser);
        }
        if (this.isFlagOnRequest(FLAG_UPDATED_USER_PW)) {
            map.put(FLAG_UPDATED_USER_PW, true);
        }
        if (this.isFlagOnRequest(FLAG_USERS_DELETED)) {
            map.put(FLAG_USERS_DELETED, true);
        }
        return map;
    }

    private UserAccount getUserFromUriParameter(String key) {
        String uri = this.vreq.getParameter(key);
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        return this.userAccountsDao.getUserAccountByUri(uri);
    }

    private List<UserAccountWrapper> wrapUserAccounts(UserAccountsSelection selection) {
        ArrayList<UserAccountWrapper> list = new ArrayList<UserAccountWrapper>();
        for (UserAccount account : selection.getUserAccounts()) {
            UserAccountWrapper wrapper = new UserAccountWrapper(account, this.findPermissionSetLabels(account), this.permittedToEdit(account), this.permittedToDelete(account));
            list.add(wrapper);
        }
        return list;
    }

    private boolean permittedToEdit(UserAccount account) {
        if (!account.isRootUser()) {
            return true;
        }
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{new ManageRootAccount()});
    }

    private boolean permittedToDelete(UserAccount account) {
        if (!this.permittedToEdit(account)) {
            return false;
        }
        UserAccount loggedInUser = LoginStatusBean.getCurrentUser((HttpServletRequest)this.vreq);
        if (loggedInUser == null) {
            return false;
        }
        return !account.getUri().equals(loggedInUser.getUri());
    }

    private List<String> findPermissionSetLabels(UserAccount account) {
        ArrayList<String> labels = new ArrayList<String>();
        if (account.isRootUser()) {
            labels.add("ROOT");
        } else {
            for (String uri : account.getPermissionSetUris()) {
                PermissionSet pSet = this.userAccountsDao.getPermissionSetByUri(uri);
                if (pSet == null) continue;
                labels.add(pSet.getLabel());
            }
        }
        return labels;
    }

    public static class Message {
        private static final String ATTRIBUTE = Message.class.getName();
        private static final Collection<String> EMPTY = Collections.emptySet();
        private final Type type;
        private final UserAccount userAccount;
        private final boolean emailWasSent;
        private final Collection<String> deletedUris;

        public static void showNewAccount(HttpServletRequest req, UserAccount userAccount, boolean emailWasSent) {
            Message message = new Message(Type.NEW_ACCOUNT, userAccount, emailWasSent, EMPTY);
            Message.setMessage(req, message);
        }

        public static void showUpdatedAccount(HttpServletRequest req, UserAccount userAccount, boolean emailWasSent) {
            Message message = new Message(Type.UPDATED_ACCOUNT, userAccount, emailWasSent, EMPTY);
            Message.setMessage(req, message);
        }

        public static void showDeletions(HttpServletRequest req, Collection<String> deletedUris) {
            Message message = new Message(Type.DELETIONS, null, false, deletedUris);
            Message.setMessage(req, message);
        }

        private static void setMessage(HttpServletRequest req, Message message) {
            req.getSession().setAttribute(ATTRIBUTE, (Object)message);
        }

        public static void applyToBodyMap(HttpServletRequest req, Map<String, Object> body) {
            HttpSession session = req.getSession();
            Object o = session.getAttribute(ATTRIBUTE);
            session.removeAttribute(ATTRIBUTE);
            if (o instanceof Message) {
                ((Message)o).applyToBodyMap(body);
            }
        }

        public Message(Type type, UserAccount userAccount, boolean emailWasSent, Collection<String> deletedUris) {
            this.type = type;
            this.userAccount = userAccount;
            this.emailWasSent = emailWasSent;
            this.deletedUris = deletedUris;
        }

        private void applyToBodyMap(Map<String, Object> body) {
            if (this.type == Type.NEW_ACCOUNT) {
                body.put("newUserAccount", new UserAccountWrapper(this.userAccount, Collections.emptyList(), true, false));
                if (this.emailWasSent) {
                    body.put("emailWasSent", Boolean.TRUE);
                }
            } else if (this.type == Type.UPDATED_ACCOUNT) {
                body.put("updatedUserAccount", new UserAccountWrapper(this.userAccount, Collections.emptyList(), true, false));
                if (this.emailWasSent) {
                    body.put("emailWasSent", Boolean.TRUE);
                }
            } else {
                body.put("deletedAccountCount", this.deletedUris.size());
            }
        }

        static enum Type {
            NEW_ACCOUNT,
            UPDATED_ACCOUNT,
            DELETIONS;

        }
    }

    public static class UserAccountWrapper {
        private final UserAccount account;
        private final List<String> permissionSets;
        private final String editUrl;
        private final boolean deletable;

        public UserAccountWrapper(UserAccount account, List<String> permissionSets, boolean showEditUrl, boolean permitDelete) {
            this.account = account;
            this.permissionSets = permissionSets;
            this.deletable = permitDelete;
            this.editUrl = showEditUrl ? UserAccountsListPage.editAccountUrl(account.getUri()) : "";
        }

        public String getUri() {
            return this.account.getUri();
        }

        public String getEmailAddress() {
            return this.account.getEmailAddress();
        }

        public String getFirstName() {
            return this.account.getFirstName();
        }

        public String getLastName() {
            return this.account.getLastName();
        }

        public int getLoginCount() {
            return this.account.getLoginCount();
        }

        public Date getLastLoginTime() {
            long time = this.account.getLastLoginTime();
            if (time > 0L) {
                return new Date(time);
            }
            return null;
        }

        public String getStatus() {
            UserAccount.Status status = this.account.getStatus();
            if (status == null) {
                return "";
            }
            return status.toString();
        }

        public List<String> getPermissionSets() {
            return this.permissionSets;
        }

        public String getEditUrl() {
            return this.editUrl;
        }

        public boolean isDeletable() {
            return this.deletable;
        }
    }
}

