/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisplayMessage {
    private static final Log log = LogFactory.getLog(DisplayMessage.class);
    private static final String NO_MESSAGE = "";
    private static final String ATTRIBUTE_NAME = DisplayMessage.class.getName();

    public static void setMessage(HttpServletRequest request, String message) {
        DisplayMessage.setMessage(request.getSession(), message);
    }

    public static void setMessage(HttpSession session, String message) {
        session.setAttribute(ATTRIBUTE_NAME, (Object)message);
        log.debug((Object)("Set message: '" + message + "'"));
    }

    public static String getMessageAndClear(HttpServletRequest request) {
        if (request == null) {
            return NO_MESSAGE;
        }
        return DisplayMessage.getMessageAndClear(request.getSession(false));
    }

    public static String getMessageAndClear(HttpSession session) {
        String message = NO_MESSAGE;
        if (session != null) {
            Object sessionMessage = session.getAttribute(ATTRIBUTE_NAME);
            if (sessionMessage != null) {
                if (sessionMessage instanceof String) {
                    log.debug((Object)("Get message: '" + sessionMessage + "'"));
                    message = (String)sessionMessage;
                }
                session.removeAttribute(ATTRIBUTE_NAME);
            } else {
                log.debug((Object)"Get no message.");
            }
        }
        return message;
    }
}

