/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.requestedAction;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import java.util.Arrays;

public abstract class AuthorizationRequest {
    public static final AuthorizationRequest AUTHORIZED = new AuthorizationRequest(){

        @Override
        public boolean isAuthorized(IdentifierBundle ids, PolicyIface policy) {
            return true;
        }
    };
    public static final AuthorizationRequest UNAUTHORIZED = new AuthorizationRequest(){

        @Override
        public boolean isAuthorized(IdentifierBundle ids, PolicyIface policy) {
            return false;
        }
    };

    public static AuthorizationRequest andAll(AuthorizationRequest ... ars) {
        return AuthorizationRequest.andAll(Arrays.asList(ars));
    }

    public static AuthorizationRequest andAll(Iterable<? extends AuthorizationRequest> ars) {
        AuthorizationRequest result = AUTHORIZED;
        for (AuthorizationRequest authorizationRequest : ars) {
            result = result.and(authorizationRequest);
        }
        return result;
    }

    public AuthorizationRequest and(AuthorizationRequest that) {
        if (that == null) {
            return this;
        }
        return new AndAuthorizationRequest(this, that);
    }

    public AuthorizationRequest or(AuthorizationRequest that) {
        if (that == null) {
            return this;
        }
        return new OrAuthorizationRequest(this, that);
    }

    public abstract boolean isAuthorized(IdentifierBundle var1, PolicyIface var2);

    private static class OrAuthorizationRequest
    extends AuthorizationRequest {
        private final AuthorizationRequest ar1;
        private final AuthorizationRequest ar2;

        private OrAuthorizationRequest(AuthorizationRequest ar1, AuthorizationRequest ar2) {
            this.ar1 = ar1;
            this.ar2 = ar2;
        }

        @Override
        public boolean isAuthorized(IdentifierBundle ids, PolicyIface policy) {
            return this.ar1.isAuthorized(ids, policy) || this.ar2.isAuthorized(ids, policy);
        }

        public String toString() {
            return "(" + this.ar1 + " || " + this.ar2 + ")";
        }
    }

    private static class AndAuthorizationRequest
    extends AuthorizationRequest {
        private final AuthorizationRequest ar1;
        private final AuthorizationRequest ar2;

        private AndAuthorizationRequest(AuthorizationRequest ar1, AuthorizationRequest ar2) {
            this.ar1 = ar1;
            this.ar2 = ar2;
        }

        @Override
        public boolean isAuthorized(IdentifierBundle ids, PolicyIface policy) {
            return this.ar1.isAuthorized(ids, policy) && this.ar2.isAuthorized(ids, policy);
        }

        public String toString() {
            return "(" + this.ar1 + " && " + this.ar2 + ")";
        }
    }
}

