/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy.setup;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.ActiveIdentifierBundleFactories;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundleFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.HasPermissionFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.HasPermissionSetFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.HasProfileOrIsBlacklistedFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.HasProxyEditingRightsFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.IsRootUserFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.IsUserFactory;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DisplayRestrictedDataToSelfPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PermissionsPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.SelfEditingPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class CommonPolicyFamilySetup
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            this.policy(ctx, new PermissionsPolicy());
            this.policy(ctx, new DisplayRestrictedDataToSelfPolicy(ctx));
            this.policy(ctx, new SelfEditingPolicy(ctx));
            this.factory(ctx, new IsUserFactory(ctx));
            this.factory(ctx, new IsRootUserFactory(ctx));
            this.factory(ctx, new HasProfileOrIsBlacklistedFactory(ctx));
            this.factory(ctx, new HasPermissionSetFactory(ctx));
            this.factory(ctx, new HasPermissionFactory(ctx));
            this.factory(ctx, new HasProxyEditingRightsFactory(ctx));
        }
        catch (Exception e) {
            ss.fatal(this, "could not run CommonPolicyFamilySetup", e);
        }
    }

    private void policy(ServletContext ctx, PolicyIface policy) {
        ServletPolicyList.addPolicy(ctx, policy);
    }

    private void factory(ServletContext ctx, IdentifierBundleFactory factory) {
        ActiveIdentifierBundleFactories.addFactory(ctx, factory);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

