/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasAssociatedIndividual;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BaseSelfEditingPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractDataPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractObjectPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.resource.AbstractResourceAction;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class SelfEditingPolicy
extends BaseSelfEditingPolicy
implements PolicyIface {
    public SelfEditingPolicy(ServletContext ctx) {
        super(ctx, BaseResourceBean.RoleLevel.SELF);
    }

    @Override
    public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
        if (whoToAuth == null) {
            return this.inconclusiveDecision("whoToAuth was null");
        }
        if (whatToAuth == null) {
            return this.inconclusiveDecision("whatToAuth was null");
        }
        ArrayList<String> userUris = new ArrayList<String>(HasAssociatedIndividual.getIndividualUris(whoToAuth));
        if (userUris.isEmpty()) {
            return this.inconclusiveDecision("Not self-editing.");
        }
        if (whatToAuth instanceof AbstractObjectPropertyStatementAction) {
            return this.isAuthorizedForObjectPropertyAction(userUris, (AbstractObjectPropertyStatementAction)whatToAuth);
        }
        if (whatToAuth instanceof AbstractDataPropertyStatementAction) {
            return this.isAuthorizedForDataPropertyAction(userUris, (AbstractDataPropertyStatementAction)whatToAuth);
        }
        if (whatToAuth instanceof AbstractResourceAction) {
            return this.isAuthorizedForResourceAction((AbstractResourceAction)whatToAuth);
        }
        return this.inconclusiveDecision("Does not authorize " + whatToAuth.getClass().getSimpleName() + " actions");
    }

    private PolicyDecision isAuthorizedForObjectPropertyAction(List<String> userUris, AbstractObjectPropertyStatementAction action) {
        String subject = action.getSubjectUri();
        Property predicate = action.getPredicate();
        String object = action.getObjectUri();
        if (!this.canModifyResource(subject)) {
            return this.cantModifyResource(subject);
        }
        if (!this.canModifyPredicate(predicate)) {
            return this.cantModifyPredicate(predicate);
        }
        if (!this.canModifyResource(object)) {
            return this.cantModifyResource(object);
        }
        if (this.userCanEditAsSubjectOrObjectOfStmt(userUris, subject, object)) {
            return this.authorizedDecision("User is subject or object of statement.");
        }
        return this.userNotAuthorizedToStatement();
    }

    private PolicyDecision isAuthorizedForDataPropertyAction(List<String> userUris, AbstractDataPropertyStatementAction action) {
        String subject = action.getSubjectUri();
        Property predicate = action.getPredicate();
        if (!this.canModifyResource(subject)) {
            return this.cantModifyResource(subject);
        }
        if (!this.canModifyPredicate(predicate)) {
            return this.cantModifyPredicate(predicate);
        }
        if (this.userCanEditAsSubjectOfStmt(userUris, subject)) {
            return this.authorizedDecision("User is subject of statement.");
        }
        return this.userNotAuthorizedToStatement();
    }

    private PolicyDecision isAuthorizedForResourceAction(AbstractResourceAction action) {
        String uri = action.getSubjectUri();
        if (!this.canModifyResource(uri)) {
            return this.cantModifyResource(uri);
        }
        return this.authorizedDecision("May add/remove resource.");
    }

    private boolean userCanEditAsSubjectOfStmt(List<String> userUris, String subject) {
        for (String userUri : userUris) {
            if (!userUri.equals(subject)) continue;
            return true;
        }
        return false;
    }

    private boolean userCanEditAsSubjectOrObjectOfStmt(List<String> userUris, String subject, String object) {
        for (String userUri : userUris) {
            if (userUri.equals(subject)) {
                return true;
            }
            if (!userUri.equals(object)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SelfEditingPolicy - " + this.hashCode();
    }
}

