/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.permissions;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.BrokenPermission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.DisplayByRolePermission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.EditByRolePermission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.PublishByRolePermission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionRegistry {
    private static final Log log = LogFactory.getLog(PermissionRegistry.class);
    private static final String ATTRIBUTE_NAME = PermissionRegistry.class.getName();
    private final Map<String, Permission> map = new HashMap<String, Permission>();

    public static boolean isRegistryCreated(ServletContext ctx) {
        return ctx.getAttribute(ATTRIBUTE_NAME) instanceof PermissionRegistry;
    }

    public static void createRegistry(ServletContext ctx, Collection<? extends Permission> permissions) {
        if (ctx == null) {
            throw new NullPointerException("ctx may not be null.");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions may not be null.");
        }
        if (ctx.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new IllegalStateException("PermissionRegistry has already been set.");
        }
        PermissionRegistry registry = new PermissionRegistry();
        registry.addPermissions(permissions);
        ctx.setAttribute(ATTRIBUTE_NAME, (Object)registry);
    }

    public static PermissionRegistry getRegistry(ServletContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx may not be null.");
        }
        Object o = ctx.getAttribute(ATTRIBUTE_NAME);
        if (o == null) {
            throw new IllegalStateException("PermissionRegistry has not been set.");
        }
        if (!(o instanceof PermissionRegistry)) {
            throw new IllegalStateException("PermissionRegistry was set to an invalid object: " + o);
        }
        return (PermissionRegistry)o;
    }

    public void addPermissions(Collection<? extends Permission> permissions) {
        for (Permission permission : permissions) {
            this.addPermission(permission);
        }
    }

    public void addPermission(Permission p) {
        String uri = p.getUri();
        if (this.map.containsKey(uri)) {
            throw new IllegalStateException("A Permission is already registered with this URI: '" + uri + "'.");
        }
        this.map.put(uri, p);
    }

    public boolean isPermission(String uri) {
        return this.map.containsKey(uri);
    }

    public Permission getPermission(String uri) {
        Permission p = this.map.get(uri);
        if (p == null) {
            log.warn((Object)("No Permission is registered for '" + uri + "'"));
            return new BrokenPermission(uri);
        }
        return p;
    }

    public static class Setup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            StartupStatus ss = StartupStatus.getBean(ctx);
            try {
                ArrayList<Permission> permissions = new ArrayList<Permission>();
                permissions.addAll(SimplePermission.getAllInstances());
                permissions.addAll(this.createDisplayByRolePermissions());
                permissions.addAll(this.createEditByRolePermissions());
                permissions.addAll(this.createPublishByRolePermissions());
                PermissionRegistry.createRegistry(ctx, permissions);
                ss.info(this, "Created the PermissionRegistry with " + permissions.size() + " permissions.");
            }
            catch (Exception e) {
                ss.fatal(this, "Failed to initialize the PermissionRegistry.", e);
            }
        }

        private Collection<Permission> createDisplayByRolePermissions() {
            ArrayList<Permission> list = new ArrayList<Permission>();
            list.add(new DisplayByRolePermission("Admin", BaseResourceBean.RoleLevel.DB_ADMIN));
            list.add(new DisplayByRolePermission("Curator", BaseResourceBean.RoleLevel.CURATOR));
            list.add(new DisplayByRolePermission("Editor", BaseResourceBean.RoleLevel.EDITOR));
            list.add(new DisplayByRolePermission("Public", BaseResourceBean.RoleLevel.PUBLIC));
            return list;
        }

        private Collection<Permission> createEditByRolePermissions() {
            ArrayList<Permission> list = new ArrayList<Permission>();
            list.add(new EditByRolePermission("Admin", BaseResourceBean.RoleLevel.DB_ADMIN));
            list.add(new EditByRolePermission("Curator", BaseResourceBean.RoleLevel.CURATOR));
            list.add(new EditByRolePermission("Editor", BaseResourceBean.RoleLevel.EDITOR));
            return list;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            sce.getServletContext().removeAttribute(ATTRIBUTE_NAME);
        }

        private Collection<Permission> createPublishByRolePermissions() {
            ArrayList<Permission> list = new ArrayList<Permission>();
            list.add(new PublishByRolePermission("Admin", BaseResourceBean.RoleLevel.DB_ADMIN));
            list.add(new PublishByRolePermission("Curator", BaseResourceBean.RoleLevel.CURATOR));
            list.add(new PublishByRolePermission("Editor", BaseResourceBean.RoleLevel.EDITOR));
            list.add(new PublishByRolePermission("Public", BaseResourceBean.RoleLevel.PUBLIC));
            return list;
        }
    }
}

