/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundleFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.UserBasedIdentifierBundleFactory;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletRequest;

public class ActiveIdentifierBundleFactories {
    private static final String ATTRIBUTE_ACTIVE_FACTORIES = ActiveIdentifierBundleFactories.class.getName();
    private final List<IdentifierBundleFactory> factories = new ArrayList<IdentifierBundleFactory>();

    public static void addFactory(ServletContextEvent sce, IdentifierBundleFactory factory) {
        if (sce == null) {
            throw new NullPointerException("sce may not be null.");
        }
        if (factory == null) {
            throw new NullPointerException("factory may not be null.");
        }
        ActiveIdentifierBundleFactories.addFactory(sce.getServletContext(), factory);
    }

    public static void addFactory(ServletContext ctx, IdentifierBundleFactory factory) {
        if (ctx == null) {
            throw new NullPointerException("ctx may not be null.");
        }
        if (factory == null) {
            throw new NullPointerException("factory may not be null.");
        }
        ActiveIdentifierBundleFactories.getActiveFactories(ctx).addFactory(factory);
    }

    public static List<String> getFactoryNames(ServletContext ctx) {
        ArrayList<String> names = new ArrayList<String>();
        ActiveIdentifierBundleFactories actFact = ActiveIdentifierBundleFactories.getActiveFactories(ctx);
        for (IdentifierBundleFactory factory : actFact.factories) {
            names.add(factory.toString());
        }
        return names;
    }

    static IdentifierBundle getIdentifierBundle(HttpServletRequest request) {
        return ActiveIdentifierBundleFactories.getActiveFactories(request).getBundleForRequest(request);
    }

    public static IdentifierBundle getUserIdentifierBundle(HttpServletRequest request, UserAccount userAccount) {
        return ActiveIdentifierBundleFactories.getActiveFactories(request).getBundleForUser(userAccount);
    }

    private static ActiveIdentifierBundleFactories getActiveFactories(HttpServletRequest req) {
        if (req == null) {
            throw new NullPointerException("req may not be null.");
        }
        return ActiveIdentifierBundleFactories.getActiveFactories(req.getSession().getServletContext());
    }

    private static ActiveIdentifierBundleFactories getActiveFactories(ServletContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx may not be null.");
        }
        Object obj = ctx.getAttribute(ATTRIBUTE_ACTIVE_FACTORIES);
        if (obj == null) {
            obj = new ActiveIdentifierBundleFactories();
            ctx.setAttribute(ATTRIBUTE_ACTIVE_FACTORIES, obj);
        }
        if (!(obj instanceof ActiveIdentifierBundleFactories)) {
            throw new IllegalStateException("Expected to find an instance of " + ActiveIdentifierBundleFactories.class.getName() + " in the context, but found an instance of " + obj.getClass().getName() + " instead.");
        }
        return (ActiveIdentifierBundleFactories)obj;
    }

    private void addFactory(IdentifierBundleFactory factory) {
        this.factories.add(factory);
    }

    private IdentifierBundle getBundleForRequest(HttpServletRequest request) {
        ArrayIdentifierBundle ib = new ArrayIdentifierBundle(new Identifier[0]);
        for (IdentifierBundleFactory ibf : this.factories) {
            ib.addAll(ibf.getIdentifierBundle(request));
        }
        return ib;
    }

    private IdentifierBundle getBundleForUser(UserAccount userAccount) {
        ArrayIdentifierBundle ib = new ArrayIdentifierBundle(new Identifier[0]);
        for (IdentifierBundleFactory ibf : this.factories) {
            if (!(ibf instanceof UserBasedIdentifierBundleFactory)) continue;
            UserBasedIdentifierBundleFactory ubibf = (UserBasedIdentifierBundleFactory)ibf;
            ib.addAll(ubibf.getIdentifierBundleForUser(userAccount));
        }
        return ib;
    }
}

