/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.validator.impl;

import edu.cornell.mannlib.vedit.validator.ValidationObject;
import edu.cornell.mannlib.vedit.validator.Validator;
import java.util.Iterator;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;

public class UrlValidator
implements Validator {
    @Override
    public ValidationObject validate(Object obj) throws IllegalArgumentException {
        ValidationObject vo = new ValidationObject();
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Expected instance of String");
        }
        IRIFactory factory = IRIFactory.jenaImplementation();
        IRI iri = factory.create((String)obj);
        if (iri.hasViolation(false)) {
            StringBuilder errorStr = new StringBuilder();
            Iterator violIt = iri.violations(false);
            while (violIt.hasNext()) {
                errorStr.append(((Violation)violIt.next()).getShortMessage()).append("  ");
            }
            vo.setValid(false);
            vo.setMessage("Please enter a valid URL.  " + errorStr);
        } else {
            vo.setValid(true);
        }
        vo.setValidatedObject(obj);
        return vo;
    }
}

