/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.validator.impl;

import edu.cornell.mannlib.vedit.validator.ValidationObject;
import edu.cornell.mannlib.vedit.validator.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class EnumValuesValidator
implements Validator {
    private HashSet legalValues = new HashSet();

    @Override
    public ValidationObject validate(Object obj) {
        ValidationObject vo = new ValidationObject();
        if (this.legalValues.contains((String)obj)) {
            vo.setValid(true);
        } else {
            vo.setValid(false);
            if (this.legalValues.size() < 7) {
                StringBuilder msgString = new StringBuilder("Please enter one of ");
                Iterator valuesIt = this.legalValues.iterator();
                while (valuesIt.hasNext()) {
                    String legalValue = (String)valuesIt.next();
                    msgString.append("'").append(legalValue).append("'");
                    if (valuesIt.hasNext()) {
                        msgString.append(", ");
                        continue;
                    }
                    msgString.append(".");
                }
                vo.setMessage(msgString.toString());
            } else {
                vo.setMessage("Please enter a legal value.");
            }
        }
        vo.setValidatedObject(obj);
        return vo;
    }

    public EnumValuesValidator(String[] legalValues) {
        Collections.addAll(this.legalValues, legalValues);
    }
}

