/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.semservices.util;

import edu.cornell.mannlib.semservices.util.MetadataNamespaceContext;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static DocumentBuilder parser;
    public static Writer writer;
    private static String indent;
    protected static final Log logger;

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (parser == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            parser = documentBuilderFactory.newDocumentBuilder();
        }
        return parser;
    }

    public static synchronized Document parse(String xmlString) throws IOException, SAXException, ParserConfigurationException {
        StringReader reader = new StringReader(xmlString);
        InputSource inputSource = new InputSource(reader);
        return XMLUtils.getDocumentBuilder().parse(inputSource);
    }

    public static synchronized Document parse(InputStream stream) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.getDocumentBuilder().parse(stream);
    }

    public static String getElementByName(Document document, String name) {
        NodeList nodes = document.getElementsByTagName(name);
        String s = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            s = node.getTextContent().trim();
        }
        return s;
    }

    public static void serializeDoc(Document doc) throws IOException {
        XMLSerializer serializer = new XMLSerializer();
        serializer.setOutputByteStream((OutputStream)System.out);
        serializer.serialize(doc);
    }

    public static String serializeDoctoString(Document doc) throws IOException {
        XMLSerializer serializer = new XMLSerializer();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        serializer.setOutputByteStream((OutputStream)bout);
        serializer.serialize(doc);
        return bout.toString();
    }

    public static void prettyPrint(String xml) {
        StreamSource xmlInput = new StreamSource(new StringReader(xml));
        StreamResult xmlOutput = new StreamResult(new StringWriter());
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        try {
            transformer.transform(xmlInput, xmlOutput);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        String formattedxml = xmlOutput.getWriter().toString();
        System.out.println(formattedxml);
    }

    public static String prettyPrintToString(String xml) {
        StreamSource xmlInput = new StreamSource(new StringReader(xml));
        StreamResult xmlOutput = new StreamResult(new StringWriter());
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        try {
            transformer.transform(xmlInput, xmlOutput);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        String formattedxml = xmlOutput.getWriter().toString();
        return formattedxml;
    }

    public static void displayNodeInfo(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                System.out.println("Document Node ");
                break;
            }
            case 1: {
                System.out.println("Element Node: " + node.getNodeName());
                break;
            }
            case 3: {
                System.out.println("Text Node: " + node.getNodeName());
                break;
            }
            case 4: {
                System.out.println("CDATA Section Node: ");
                break;
            }
            case 8: {
                System.out.println("Comment Node ");
                break;
            }
            case 7: {
                System.out.println("Processing Instruction Node ");
                break;
            }
            case 5: {
                System.out.println("Entity Reference Node ");
                break;
            }
            case 10: {
                System.out.println("Document Type Node ");
            }
        }
    }

    public static void serializeNode(Node node) throws IOException {
        if (writer == null) {
            writer = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                writer.write("<?xml version=\"");
                writer.write(doc.getXmlVersion());
                writer.write("\" encoding=\"UTF-8\" standalone=\"");
                if (doc.getXmlStandalone()) {
                    writer.write("yes");
                } else {
                    writer.write("no");
                }
                writer.write("\"?>\n");
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    XMLUtils.serializeNode(nodes.item(i));
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write("<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    writer.write(" " + current.getNodeName() + "=\"");
                    XMLUtils.print(current.getNodeValue());
                    writer.write("\"");
                }
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        XMLUtils.serializeNode(children.item(i));
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        writer.write("");
                    }
                }
                writer.write("</" + name + ">");
                break;
            }
            case 3: {
                XMLUtils.print(node.getNodeValue());
                break;
            }
            case 4: {
                writer.write("CDATA");
                XMLUtils.print(node.getNodeValue());
                writer.write("");
                break;
            }
            case 8: {
                writer.write("<!-- " + node.getNodeValue() + " -->\n");
                break;
            }
            case 7: {
                writer.write("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>\n");
                break;
            }
            case 5: {
                writer.write("&" + node.getNodeName() + ";");
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                String publicId = docType.getPublicId();
                String systemId = docType.getSystemId();
                String internalSubset = docType.getInternalSubset();
                writer.write("<!DOCTYPE " + docType.getName());
                if (publicId != null) {
                    writer.write(" PUBLIC \"" + publicId + "\" ");
                } else {
                    writer.write(" SYSTEM ");
                }
                writer.write("\"" + systemId + "\"");
                if (internalSubset != null) {
                    writer.write(" [" + internalSubset + "]");
                }
                writer.write(">\n");
            }
        }
        writer.flush();
    }

    private static void print(String s) throws IOException {
        if (s == null) {
            return;
        }
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                case '\r': {
                    writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    public static Node getNodeWithXpath(Object obj, String expression) {
        Node root = null;
        if (obj instanceof Document) {
            Document doc = (Document)obj;
            root = doc.getDocumentElement();
        } else {
            root = (Node)obj;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new MetadataNamespaceContext());
        Node result = null;
        try {
            result = (Node)xpath.evaluate(expression, root, XPathConstants.NODE);
            return result;
        }
        catch (XPathExpressionException e) {
            logger.error((Object)"XPathExpressionException ", (Throwable)e);
            return null;
        }
    }

    static {
        indent = "";
        logger = LogFactory.getLog(XMLUtils.class);
    }
}

